#!/bin/bash
#
#  umx-init.sh
#
#  This is very first program during the boot to initialize system for UMx.
#
#  Copyright (c) 2002-2009 Userful Corporation Ltd.
#
#  Description:
#    Pre-initialization for UMx. Only place to have distro specific code.
#
#  Called from:
# 	- umx-init initscript, or
# 	- umx-init.conf
#

## XXX
##  - This is the only place to have the distro specific code.
##  - No other program should have distro specific code.

logfile="/var/log/userful-start.log"
function bin() {
    echo $(cd `dirname $0` && pwd)	
}

echo "SOURCING $(bin)/gconf.sh" >> $logfile
source "$(bin)/gconf.sh"
source "$(bin)/userful-bash-lib.sh"

#log file should be world read/writable.
chmod a+rw $logfile

##
## Check os-info
if [ ! -f /etc/userful/os-info ]; then
    /opt/userful/bin/dm-check-os.sh
fi
if [ -f /etc/userful/os-info ]; then
    source /etc/userful/os-info
fi

if [ -z "$OSNAME" -o -z "$OSVER" ]; then
	echo "`date +"%b %d %T"` $0: OSNAME/OSVER is not avaiable." >> $logfile
	exit 1
fi

##
## Create distro.conf if it doesn't exist.
if [ ! -f /tmp/distro.conf ]; then
	/opt/userful/bin/umx-distro-conf.py --osname $OSNAME --osver $OSVER
fi
if [ -f /tmp/distro.conf ]; then
	source /tmp/distro.conf
fi

##
## Check XTYPE
if [ -e /etc/sysconfig/xtype ]; then
    source /etc/sysconfig/xtype
else
    echo "`date +"%b %d %T"` $0: /etc/sysconfig/xtype is not avaiable." >> $logfile
fi
if [ -z "$XTYPE" ]; then
    XTYPE="MULTI"
fi

## Log
echo "`date +"%b %d %T"` $0: started..." >> $logfile

##
## This is for backward compatibility..
if [ "$OSNAME" == "ubuntu" -a "$OSVER" == "9.04" ]; then

    if [ ! -e /etc/X11/umx-start ]; then
        echo "umx-init: Create /etc/X11/umx-start."  >> $logfile
        ln -s /opt/userful/bin/umx-start /etc/X11/umx-start
    fi

    # Disable /etc/init.d/gdm
    if [ -e /etc/init.d/gdm ]; then
        echo "umx-init: Ranme /etc/init.d/gdm"  >> $logfile
        mv -f /etc/init.d/gdm /etc/init.d/gdm.multi-save
        update-rc.d -f gdm remove
    fi

    # Disable /etc/init.d/gdm
    if [ -e /etc/init.d/kdm ]; then
        echo "umx-init: Ranme /etc/init.d/kdm"  >> $logfile
        mv -f /etc/init.d/kdm /etc/init.d/kdm.multi-save
        update-rc.d -f kdm remove
    fi

    if [ ! -e /etc/event.d/dm-start ]; then
        echo "umx-init: Add /etc/event.d/dm-start"  >> $logfile
        cp -f /etc/userful/setup/dm-start.upstart /etc/event.d/dm-start
    fi

else
    ###################
    # Single user mode
    ###################
    if [ "$XTYPE" == "SINGLE" -o "$XTYPE" == "single" ]; then
        ##
        ## Restore the configuration of DisplayManager
        if [ -n "$DMCONFIG" ]; then
            if [ -e $DMCONFIG.multi-save ]; then
                mv -f $DMCONFIG.multi-save  $DMCONFIG
            elif [ -e $DMCONFIG.multi-remove ]; then
                rm -f $DMCONFIG  $DMCONFIG.multi-remove
            fi
        fi

        ##
        ## Restore DisplayManager if requried. - DMINIT
        if [ -n "$DMSTART" -a "$DMSTART" == "disable" ]; then
            # Display Manager init script was disabled by UMx

            if [ -e /etc/init.d/$DMINIT ]; then
                if which chkconfig > /dev/null ; then
                    chkconfig --add $DMINIT > /dev/null
                elif which update-rc.d > /dev/null ; then
                    update-rc.d $DMINIT defaults $DMSEQUENCE > /dev/null
                fi
            fi
        fi

        ##
        ## Remove umx-start job. No specific restore is required for inittab.
        if [ "$STARTUP" == "upstart" ]; then
            ##
            ## Remove UPSTART jobs
            if [ -n "$UMXSTART" -a -e $UMXSTART ]; then
                rm -f $UMXSTART
            fi
        fi

        ##
        ## FIXME
        ##  - It's not possible to start GDM(2.27.4) on Ubuntu 9.10 without local display.
        ##  - This feature will be reimplemented again in the future gdm version with ConsoleKit support
        ##  - "--no-console" is used in SLED 11 to start GDM without local display.
        ##  - Fix for Ubuntu 9.10 for now:
        ##    : rename /usr/bin/Xorg to /usr/bin/Xorg.umx-save
        ##    : create symbolic link /usr/bin/Xorg to /opt/userful/bin/login-server

        ##
        ## Restore /usr/bin/Xorg if required (if it is a symbolic link)
        if [ -h /usr/bin/Xorg ]; then
            rm -f /usr/bin/Xorg
            mv -f /usr/bin/Xorg.umx-save /usr/bin/Xorg
        fi

        ##
        ## TODO
        ## Distro specific configuration may be required.
        ## Restore session startup programs.
        #if [ "$OSNAME" == "" -a "$OSVER" == "" ]; then
        #else
            # Novell 11, Ubuntu 9.04
		    if [ -f /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop.multi-save ]; then
			    mv /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop.multi-save \
			        /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop
		    fi
		    if [ -f /etc/xdg/autostart/gnome-at-session.desktop.multi-save ]; then
			    mv /etc/xdg/autostart/gnome-at-session.desktop.multi-save \
			        /etc/xdg/autostart/gnome-at-session.desktop
		    fi
		    if [ -f /etc/xdg/autostart/pulseaudio.desktop.multi-save ]; then
		    	mv /etc/xdg/autostart/pulseaudio.desktop.multi-save \
			        /etc/xdg/autostart/pulseaudio.desktop
		    fi
        #fi

    ###################
    # Multi user mode
    ###################
    elif [ "$XTYPE" == "MULTI" -o "$XTYPE" == "multi" ]; then

        ##
        ## Backup the configuration of Display Manager.
        ## The saved configuration will be restored when 1)UMx is uninstalled or 2)XTYPE is single.
        if [ -n "$DMCONFIG" ]; then
            ## Check DM config file.
            if [ -e $DMCONFIG ]; then
                # If $DMCONFIG exists, make a backup file if not exists.
                if [ ! -e $DMCONFIG.multi-save -a ! -e $DMCONFIG.multi-remove ]; then
                    cp -f $DMCONFIG  $DMCONFIG.multi-save
                fi
            else
                # If $DMCONFIG NOT exists, copy one from /etc/userful/setup/ directory.
                DMCONFIG_NAME=`basename $DMCONFIG`
                cp -f /etc/userful/setup/$DMCONFIG_NAME.$OSNAME-$OSVER ${DMCONFIG/DMCONFIG_NAME/}
                cp -f $DMCONFIG $DMCONFIG.multi-remove
        	fi
        fi

        ##
        ## Diable DisplayManager if requried.
        if [ -n "$DMSTART" -a "$DMSTART" == "disable" ]; then
            if [ -n "$DMINIT" -a -e /etc/init.d/$DMINIT ]; then
                if which chkconfig > /dev/null ; then
                    chkconfig --del $DMINIT > /dev/null
                elif which update-rc.d > /dev/null ; then
                    update-rc.d -f $DMINIT remove > /dev/null
                fi
            fi
        fi

        ##
        ## Check UMX upstart job
        if [ "$STARTUP" == "upstart" ]; then
            if [ -n "$UMXSTART" -a ! -e $UMXSTART ]; then
                UMXSTART_NAME=`basename $UMXSTART`
                cp -f /etc/userful/setup/$UMXSTART_NAME.$OSNAME-$OSVER ${UMXSTART/UMXSTART_NAME/}
            fi
        fi

        #####################################################################
        ## XXX - Distro specific settings.
        ##  - Distro specific configuration is required.
        ##  - Will be hard to make a generic code with config file
        #####################################################################
        if [ "$OSNAME" == "novell" -a "$OSVER" == "11" ]; then
            #  SLED 11 needs to update /etc/sysconfig/displaymanager to enable xdmcp 
           	#+and disable local X server
            sed -i -e "s/DISPLAYMANAGER_REMOTE_ACCESS=.*/DISPLAYMANAGER_REMOTE_ACCESS=\"yes\"/g" $DMCONFIG
            sed -i -e "s/DISPLAYMANAGER_STARTS_XSERVER=.*/DISPLAYMANAGER_STARTS_XSERVER=\"no\"/g" $DMCONFIG

        elif [ "$OSNAME" == "ubuntu" -a "$OSVER" == "9.10" ]; then
            ##
            ## FIXME
            ##  - It's not possible to start GDM(2.27.4) on Ubuntu 9.10 without local display.
            ##  - It will be reimplemented again in the future gdm version with ConsoleKit support
            ##  - "--no-console" is used in SLED 11 to start GDM without local display.
            ##  - Fix for Ubuntu 9.10 for now:
            ##    : rename /usr/bin/Xorg to /usr/bin/Xorg.umx-save
            ##    : create symbolic link /usr/bin/Xorg to /opt/userful/bin/login-server

            # if /usr/bin/Xorg is not the symbolic link to login-server
            if [ ! -h /usr/bin/Xorg ]; then
                mv -f /usr/bin/Xorg /usr/bin/Xorg.umx-save
                ln -sf /opt/userful/bin/login-server /usr/bin/Xorg
            fi
        fi

            ## XXX
			## Update GConf configuration
			## 	- Each distro may need to have different GConf key updates.
			## SLED 11, Ubuntu 9.10
			log "Update GConf configuration"
			$(save "direct" "/apps/gnome_settings_daemon/plugins/xrandr/active" "bool" "false")
			$(save "direct" "/apps/gnome_settings_daemon/xrandr/rotate_tablet_with_monitor" "bool" "false")
			$(save "direct" "/apps/gnome_settings_daemon/xrandr/show_notification_icon" "bool" "false")
			$(save "direct" "/apps/gdm/simple-greeter/settings-manager-plugins/xrandr/active" "bool" "false")


            ## XXX
            ## Update startup programs.
            ## Each distro may have different set of starup programs.
		    if [ -f /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop ]; then
			    mv /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop \
			        /usr/share/gdm/autostart/LoginWindow/gnome-mag.desktop.multi-save
		    fi
		    ## gnome-at-session exec gnome-at-visual in SLED 11
		    if [ -f /etc/xdg/autostart/gnome-at-session.desktop ]; then
			    mv /etc/xdg/autostart/gnome-at-session.desktop \
			        /etc/xdg/autostart/gnome-at-session.desktop.multi-save
		    fi
            ## start-pulseaudio-x11 causes audio problem for multiple users (SLED11)
            ## Only first login user on a station can use audio device.
            ##  - /etc/xdg/autostart/pulseaudio.desktop uses start-pulseaudio-x11
		    if [ -f /etc/xdg/autostart/pulseaudio.desktop ]; then
			    mv /etc/xdg/autostart/pulseaudio.desktop \
			        /etc/xdg/autostart/pulseaudio.desktop.multi-save
		    fi
    fi # SINGLE or MULTI
fi
