#!/bin/bash
#
# dm-initialize.sh
#
#    Initialization. This script should work for every distros.
#
#    Copyright (c) 2002-2008 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# Disable vtlock
#/opt/userful/bin/vtlock -disable

# Update grub.conf to disable rhgb in FC
if [ -f /boot/grub/grub.conf ]; then
	if [ ! -e /boot/grub/grub.conf.multi-save ]; then
		cp /boot/grub/grub.conf /boot/grub/grub.conf.multi-save
	fi
	sed -i -e "s/rhgb[[:space:]]*quiet//g" /boot/grub/grub.conf
	sed -i -e "s/rhgb//g" /boot/grub/grub.conf
fi

# Stop redhat graphical boot if it exist
if [ -x /usr/bin/rhgb-client ]; then
	/usr/bin/rhgb-client --quit

	while pgrep rhgb > /dev/null 2>&1
	do
		sleep 1
	done
	while pgrep Xorg > /dev/null 2>&1
	do
		sleep 1
	done
fi

###############
# remove files 
###############
rm -f /tmp/mx-trial
rm -f /tmp/mx-config-error
rm -f /etc/usbinput.tmp
rm -f /tmp/unplug-inputdev
rm -f /tmp/unplug.tmp
rm -f /tmp/plug-inputdev
rm -f /tmp/touchscreen-dev

rm -f /opt/userful/locks/user.screen*

# Create dm directory under /var/log
if [[ ! -d /var/log/dm ]]; then
    mkdir /var/log/dm
fi

# Check if MX is running already
if [ -e /var/run/x.pid ]; then
	if [ -e /proc/`cat /var/run/x.pid` ]; then
		# MX is running.
		:
	else
		/opt/userful/bin/dm-backup-log.sh
		rm -f /var/run/pid.kbdlink*
	fi
else
	/opt/userful/bin/dm-backup-log.sh
	rm -f /var/run/pid.kbdlink*
fi

if [ ! -d /etc/X11/Xinput ]; then
	mkdir /etc/X11/Xinput
fi

if [ ! -d /opt/userful/locks ]; then
	mkdir /opt/userful/locks
fi

# Create softlink for backward compatibility
if [ ! -f /sbin/userful-config-display ]; then
	ln -s /opt/userful/bin/userful-config-display /sbin/userful-config-display
fi

# Check zenity
if [ ! -f /usr/bin/zenity ]; then
	if [ -f /opt/gnome/bin/zenity ]; then
		ln -s /opt/gnome/bin/zenity /usr/bin/zenity
	fi
fi

#############################
## create softlink for Fonts
#############################
## fonts, XErrorDB, XKeysymDB, app-defaults, locale, xkb

##
## Check /opt/MX11R7/share/X11 and /opt/MX11R7/lib/X11 directories.
## If thery are softlink, then delete it and make directories.
if [ -L /opt/MX11R7/share/X11 ]; then
    rm -f /opt/MX11R7/share/X11
    mkdir /opt/MX11R7/share/X11
fi
if [ -L /opt/MX11R7/lib/X11 ]; then
    rm -f /opt/MX11R7/lib/X11
    mkdir /opt/MX11R7/lib/X11
fi

## fonts
if [ ! -e /opt/MX11R7/share/X11/fonts ]; then

    if [ -e /usr/share/fonts/misc ]; then
        ln -sf /usr/share/fonts /opt/MX11R7/share/X11/

    elif [ -e /usr/share/fonts/X11/misc ]; then
        ln -sf /usr/share/fonts/X11 /opt/MX11R7/share/X11/fonts

    elif [ -e /usr/share/X11/fonts/misc ]; then
        ln -sf /usr/share/X11/fonts /opt/MX11R7/share/X11/

    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"font\" directory." >> $logfile
    fi
fi

# fonts in /opt/MX11R7/lib/X11/ directory
if [ ! -e /opt/MX11R7/lib/X11/fonts ]; then
    if [ -e /opt/MX11R7/share/X11/fonts ]; then
        ln -sf /opt/MX11R7/share/X11/fonts /opt/MX11R7/lib/X11/
    fi
fi

## XErrorDB
if [ ! -e /opt/MX11R7/share/X11/XErrorDB ]; then
    if [ -e /usr/share/X11/XErrorDB ]; then
        ln -sf /usr/share/X11/XErrorDB /opt/MX11R7/share/X11/
    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"XErrorDB\"." >> $logfile
    fi
fi

## XKeysymDB
if [ ! -e /opt/MX11R7/share/X11/XKeysymDB ]; then
    if [ -e /usr/share/X11/XKeysymDB ]; then
        ln -sf /usr/share/X11/XKeysymDB /opt/MX11R7/share/X11/
    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"XKeysymDB\"." >> $logfile
    fi
fi

## app-defaults
if [ ! -e /opt/MX11R7/share/X11/app-defaults ]; then
    if [ -e /usr/share/X11/app-defaults ]; then
        ln -sf /usr/share/X11/app-defaults /opt/MX11R7/share/X11/
    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"app-defaults\"." >> $logfile
    fi
fi

## locale
if [ ! -e /opt/MX11R7/share/X11/locale ]; then
    if [ -e /usr/share/X11/locale ]; then
        ln -sf /usr/share/X11/locale /opt/MX11R7/share/X11/
    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"locale\"." >> $logfile
    fi
fi

## xkb
if [ ! -e /opt/MX11R7/share/X11/xkb ]; then
    if [ -e /usr/share/X11/xkb ]; then
        ln -sf /usr/share/X11/xkb /opt/MX11R7/share/X11/
    else
        echo "`date +"%b %d %T"` $ProgramName: Unable to find \"xkb\"." >> $logfile
    fi
fi

## compiled
if [ ! -e /opt/MX11R7/share/X11/xkb/compiled ]; then
    mkdir /opt/MX11R7/share/X11/xkb/compiled
fi

# check the symbolic link for the X server exist.
# SuSE varients have different link path for X.
if [ ! -x /usr/X11R6/bin/X ]; then
	rm -f /usr/X11R6/bin/X
	if [ -d /var/X11R6/bin ]; then  # For SuSE linux
		ln -s /var/X11R6/bin/X /usr/X11R6/bin/X
		if [ -x /usr/X11R6/bin/XFree86 ]; then
	       	ln -s /usr/X11R6/bin/XFree86 /var/X11R6/bin/X
	   	elif [ -x /usr/X11R6/bin/Xorg ]; then
	       	ln -s /usr/X11R6/bin/Xorg /var/X11R6/bin/X
	   	fi
    else
		if [ -x /usr/X11R6/bin/XFree86 ]; then
	       	ln -s /usr/X11R6/bin/XFree86 /usr/X11R6/bin/X
	   	elif [ -x /usr/X11R6/bin/Xorg ]; then
	       	ln -s /usr/X11R6/bin/Xorg /usr/X11R6/bin/X
	   	fi
	fi
fi

# check some directories and files needed
# In FC5 (new X Server), some directories and files don't exist. 
if [ ! -e /usr/X11R6/lib/X11/xkb ]; then
	if [ -e /usr/share/X11/xkb ]; then
		mkdir -p /usr/X11R6/lib/X11
		ln -s /usr/share/X11/xkb /usr/X11R6/lib/X11/xkb
	fi
fi

if [ ! -e /usr/X11R6/lib/X11/xkb/compiled ]; then
	if [ -e /var/lib/xkb ]; then
		ln -s /var/lib/xkb /usr/X11R6/lib/X11/xkb/compiled
	fi
fi

if [ ! -e /usr/X11R6/lib/X11/xkb/xkbcomp ]; then
	if [ -e /usr/bin/xkbcomp ]; then
		ln -s /usr/bin/xkbcomp /usr/X11R6/lib/X11/xkb/xkbcomp
	fi
fi

# check /opt/MX11R7/share/X11/xkb directory
if [ ! -e /opt/MX11R7/share/X11/xkb ]; then
	if [ -e /etc/X11/xkb ]; then # Ubuntu 6.10
		ln -s /etc/X11/xkb /opt/MX11R7/share/X11/xkb
	fi
fi

# check /opt/MX11R7/bin/xkbcomp
if [ ! -e /opt/MX11R7/bin/xkbcomp ]; then
		
	if [ -e /usr/bin/xkbcomp ]; then # FC6
		ln -s /usr/bin/xkbcomp /opt/MX11R7/bin/xkbcomp

	elif [ -e /usr/X11R6/bin/xkbcomp ]; then # Novell
		ln -s /usr/X11R6/bin/xkbcomp /opt/MX11R7/bin/xkbcomp
	fi
fi

if [ ! -d /etc/sysconfig ]; then
    mkdir /etc/sysconfig
fi

# check current Display Manager
if [ -f /etc/sysconfig/desktop -o -f /etc/sysconfig/displaymanager ]; then
	if [ -f /etc/sysconfig/desktop ]; then
		source /etc/sysconfig/desktop
	fi
	if [ -f /etc/sysconfig/displaymanager ]; then
		source /etc/sysconfig/displaymanager
	fi

	case "$DISPLAYMANAGER" in
		GNOME|GDM|gnome|gdm|Gnome)  CURRENTDM=gdm ;;
		KDE|KDM|kde|kdm)    CURRENTDM=kdm ;;
		XDM|xdm)    CURRENTDM=xdm ;;
		*)  : ;; #echo "Unsupported Display manager specified"
	esac
fi

# Set ud for Userful Desktop
if [ -f /etc/init.d/Userful-Desktop-startup ]; then
	CURRENTDM=ud

elif [[ -n "$CURRENTDM" ]]; then

    ##
    ## TODO:
    ##   - In openSuSE, PATH doesn't include /opt/gnome/bin/ 
    ##   - Need to check for KDM
    if ! which $CURRENTDM > /dev/null 2>&1; then
        if [[ "$CURRENTDM" == "gdm" && -e /opt/gnome/bin/gdm ]]; then
            CURRENTDM=gdm
        fi
    fi
else
    # Search gdm, kdm and xdm.
	if which gdm >/dev/null 2>&1; then
        CURRENTDM=gdm
		echo "DISPLAYMANAGER=GNOME" > /etc/sysconfig/desktop 
    elif [[ -e /opt/gnome/bin/gdm ]]; then
       	CURRENTDM=gdm
		echo "DISPLAYMANAGER=GNOME" > /etc/sysconfig/desktop 
	elif which kdm >/dev/null 2>&1; then
       	CURRENTDM=kdm
		echo "DISPLAYMANAGER=KDM" > /etc/sysconfig/desktop 
	elif which xdm >/dev/null 2>&1; then
       	CURRENTDM=xdm
		echo "DISPLAYMANAGER=XDM" > /etc/sysconfig/desktop 
	fi
fi

# check if Display Manager has been changed from last time
# If it has been changed, need to reconfigure dm config file
if [ -f /etc/userful/currentdm ]; then
	if [ -z "$CURRENTDM" ] ; then
		rm -f /etc/X11/xdm/Xservers
	elif ! grep $CURRENTDM /etc/userful/currentdm > /dev/null 2>&1; then
		rm -f /etc/X11/xdm/Xservers
	fi
fi
echo "CURRENTDM=$CURRENTDM" > /etc/userful/currentdm

# add comments into xorg.conf
if [ -e /etc/X11/xorg.conf ]; then
	TMP=`head -n 1 /etc/X11/xorg.conf`

	if [ "$TMP" != "# Note:" ]; then
		echo "# Note:" > /tmp/xorg.conf.tmp
		echo "# This is the default configuration file for Xorg.  To change the Desktop" >> /tmp/xorg.conf.tmp
		echo "# Multiplier configuration, you need to edit the userful.Mxorg.conf file." >> /tmp/xorg.conf.tmp
		echo "" >> /tmp/xorg.conf.tmp
		cat /etc/X11/xorg.conf >> /tmp/xorg.conf.tmp
		rm -f /etc/X11/xorg.conf
		mv -f /tmp/xorg.conf.tmp /etc/X11/xorg.conf
	fi
fi

#
# Disable SELINUX
#
if [[ -f /etc/selinux/config ]]; then
	sed -i -e "s/^SELINUX=.*/SELINUX=disabled/g" /etc/selinux/config
fi

#
# Make soft link for userful command tool so that "userful" command is available
#
if [[ -x /opt/userful/bin/userful-command-tool.sh ]]; then
	ln -sf /opt/userful/bin/userful-command-tool.sh /usr/local/bin/userful
fi

##
## Remove sun* drivers if they exist.
## Sun driver causes problem for "X -configure" operation in SuSE10.2
if [[ -d /usr/lib/xorg/modules/drivers ]]; then
    rm -f /usr/lib/xorg/modules/drivers/sun*
elif [[ -d /usr/lib64/xorg/modules/drivers ]]; then
    rm -f /usr/lib64/xorg/modules/drivers/sun*
fi

##
## Create a softlink for libwfb.so if it exists.
if [[ -e /usr/lib/xorg/modules/extensions/nvidia/libwfb.so ]] && [[ ! -e /usr/lib/xorg/modules/extensions/libwfb.so ]]; then
    ln -sf /usr/lib/xorg/modules/extensions/nvidia/libwfb.so /usr/lib/xorg/modules/extensions/libwfb.so
elif [[ -e /usr/lib64/xorg/modules/extensions/nvidia/libwfb.so ]] && [[ ! -e /usr/lib64/xorg/modules/extensions/libwfb.so ]]; then
    ln -sf /usr/lib64/xorg/modules/extensions/nvidia/libwfb.so /usr/lib64/xorg/modules/extensions/libwfb.so
fi

##
## Create sys-id(/etc/userful/sys-id) everytime.. It doesn't hurt.
if [[ -x /opt/userful/bin/dm-gen-info ]]; then
    /opt/userful/bin/dm-gen-info -sysid
fi

##
## Make sure that the hotplug rule exist under /etc/udev/rules.d/ 
if [[ -d /etc/udev/rules.d ]]; then
    if [[ ! -f /etc/udev/rules.d/99-userful-hotplug.rules ]]; then
        cp -f /etc/userful/setup/99-userful-hotplug.rules /etc/udev/rules.d/
    fi
fi

##
## Rename failesafe script for Kubuntu 8.04
if [[ -e /etc/gdm/failsafeDexconf ]]; then
    mv -f /etc/gdm/failsafeDexconf /etc/gdm/failsafeDexconf.multi-save
fi
if [[ -e /etc/gdm/failsafeXinit ]]; then
    mv -f /etc/gdm/failsafeXinit /etc/gdm/failsafeXinit.multi-save
fi
if [[ -e /etc/gdm/failsafeXServer ]]; then
    mv -f /etc/gdm/failsafeXServer /etc/gdm/failsafeXServer.multi-save
fi

##
## Check Intel/i810 driver and NoAccel option
##  - intel/i810 driver without NoAccel causes X crashing.
if [ -e /etc/X11/userful.Mxorg.conf ]; then

    # Check intel driver
    if grep "\<intel\>" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
        # Check NoAccel option
        if ! grep "\<NoAccel\>" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
            sed -i -e "s/\"intel\"/\"vesa\"/" /etc/X11/userful.Mxorg.conf
        fi
    fi

    # Check i810 driver
    if grep "\<i810\>" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
        # Check NoAccel option
        if ! grep "\<NoAccel\>" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
            sed -i -e "s/\"i810\"/\"vesa\"/" /etc/X11/userful.Mxorg.conf
        fi
    fi
fi

##
## Check pixman library and delete the same library in Multi-X.
## 
if [ -e /usr/lib/libpixman-1.so.0 ]; then
    rm -f /opt/MX11R7/lib/libpixman-1.so*
fi

##
## Create distro.conf
/opt/userful/bin/dm-check-os.sh
source /etc/userful/os-info
if [ -e /etc/userful/umx-distro.conf -a -e /opt/userful/bin/umx-distro-conf.py ]; then
    rm -f /tmp/distro.conf
    /opt/userful/bin/umx-distro-conf.py --osname $OSNAME --osver $OSVER
fi

