#!/bin/bash
#
# NAME
#   multistation-storage-uninstall.sh
#
# AUTHOR
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
# 	- pre-script before uninstallation.
# 	- restore hal scritps
#

# resotre hal.conf
if [ -f /etc/dbus-1/system.d/hal.conf.multi-save ]; then 
	mv -f /etc/dbus-1/system.d/hal.conf.multi-save /etc/dbus-1/system.d/hal.conf
fi

# resotre PolicyKit.conf
if [[ -f /etc/PolicyKit/PolicyKit.conf.multi-save ]]; then
    mv -f /etc/PolicyKit/PolicyKit.conf.multi-save /etc/PolicyKit/PolicyKit.conf
fi

#
# resotre 20-storage-methods.fdi
#if [ -f /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi ]; then # FC6
#	sed -i -e "s/userful-storage-mount/hal-storage-mount/g" /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi
#fi

#
# remove fdi for the storage device hotplug
#if [ -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-storage-policy.fdi ]; then #FC6
#	rm -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-storage-policy.fdi 
#fi

#
# Restore gdm pam module
# need to check if the audio support package exists.
if [ ! -f /opt/userful/bin/multistation-audio-config.sh -a -e /etc/pam.d/gdm ]; then
	#
	# Restore pam_console for FC
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
		NEW_PAM_MODULE=${PAM_MODULE:1}
		sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
	fi

	#
	# Restore pam_devperm for SuSE
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
		NEW_PAM_MODULE=${PAM_MODULE:1}
		sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
	fi
fi
