#!/usr/bin/env python
#
# user-interface.py - Contains the UI code 
#
# Jason Kim <jason@userful.com>
#
# Description:
#   - This python script is called when a user mounts a storage device.
#   - Mounted storage device should be unmounted to save data properly.
#   - This script launches a message dialog to show unmount information.
#
# Called from: userful-storage-mount, multistation-storage-permission-check.sh
#

import gtk
import sys
import os
sys.path.append('/opt/userful/bin/')

##
## Loading image from file
##
def load_image(file, file_back):
    pix = None
    
    try:
      pix = gtk.gdk.pixbuf_new_from_file(file)
    except:
      try:
         pix = gtk.gdk.pixbuf_new_from_file(file_back)
      except:
         pass

    image = gtk.Image()
    
    if pix:       
       image.set_from_pixbuf(pix)

    return image

##
## Icon for windows
##
iconPixbuf = None
try:
    #iconPixbuf = gtk.gdk.pixbuf_new_from_file("/opt/userful/pixmaps/blockdevice.png")
    iconPixbuf = gtk.gdk.pixbuf_new_from_file("../pixmaps/blockdevice.png")
except:
    pass

##
## childWindow Class
##
class mountWarning:
    
    def destroy(self, *args):
        gtk.main_quit()
    
    def __init__(self, doDebug=None, backend=None):
    
        self.doDebug = doDebug

    def okayClicked(self, *args):
        if self.doDebug:
            print "OK clicked, sys.argv[1]= %s" % sys.argv[1]
        self.mainWindow.destroy()
        self.destroy()

    def main(self):

        if self.doDebug:
            print "Running from command-line..."
            
        self.mainWindow = gtk.Dialog()
        self.mainWindow.vbox.set_spacing(5)
        self.mainWindow.connect("destroy", self.destroy)

        self.mainWindow.set_title("Storage Device Safety")
        self.mainWindow.set_border_width(10)
        self.mainWindow.set_position(gtk.WIN_POS_CENTER)
        self.mainWindow.set_icon(iconPixbuf)
        self.mainWindow.set_position(gtk.WIN_POS_MOUSE)
        
        self.okButton = self.mainWindow.add_button('gtk-ok', 0)
        self.okButton.connect("clicked", self.okayClicked)
        
        ##
        ## Entire message
        self.toplevel =  gtk.VBox()
        self.toplevel.set_spacing(10)

        ## A box with icon and Warning message...
        self.message_box = gtk.HBox()
        self.message_box.set_spacing(5)
        self.icon = load_image("../pixmaps/blockdevice.png",
                               "/opt/userful/pixmaps/blockdevice.png")
        self.message_box.pack_start(self.icon, False)

        ##Add label
        self.label = gtk.Label("The \"%s\" device can now be used.\n" %sys.argv[1])
                              

        self.label.set_line_wrap(True)
        self.message_box.pack_start(self.label, False, padding=15)

        # add message_box to toplevel
        self.toplevel.pack_start(self.message_box, False)

        ## A box with unmount instruction .
        self.message_box = gtk.HBox()
        self.message_box.set_spacing(5)

        self.label = gtk.Label( "To safely remove it when you are done, \n"
                               "right-click on the device icon and select \n"
                               "\"Unmount\" from the popup menu.")

        self.message_box.pack_start(self.label, False, padding=70)
        self.toplevel.pack_start(self.message_box, False)

        #Remove the hsep from the dialog.  It's ugly
        hsep = self.mainWindow.get_children()[0].get_children()[0]
        self.mainWindow.get_children()[0].remove(hsep)

        self.mainWindow.vbox.pack_start(self.toplevel)
        self.mainWindow.show_all()
        gtk.main()

if __name__ == "__main__":
    app = mountWarning(doDebug=False)
    app.main()
