#!/bin/bash
#
# NAME
#   multistation-storage-install.sh
#
# AUTHOR
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
# 	- post-script after installation
# 	- update hal scripts
#

# TODO:
#	- may need to do something if system uses submountd.
#	- update hal scripts to control mount

function check_arch()
{
    case $(uname -m) in
        x86_64|ia64)
        echo "lib64"
        ;;
    *)
        echo "lib"
        ;;
    esac
}

#
# Update hal.conf
if [ -f /etc/dbus-1/system.d/hal.conf ]; then # FC6, SLED10
	if [ ! -f /etc/dbus-1/system.d/hal.conf.multi-save ]; then
		cp /etc/dbus-1/system.d/hal.conf /etc/dbus-1/system.d/hal.conf.multi-save
	fi
    if [[ -x /opt/userful/bin/umx-storage-update-hal-config.py ]]; then
        /opt/userful/bin/umx-storage-update-hal-config.py /etc/dbus-1/system.d/hal.conf
        chmod a+r /etc/dbus-1/system.d/hal.conf
    fi
fi

# Update PolicyKit.conf
if [[ -f /etc/PolicyKit/PolicyKit.conf ]]; then
    if [[ ! -f /etc/PolicyKit/PolicyKit.conf.multi-save ]]; then
        cp /etc/PolicyKit/PolicyKit.conf /etc/PolicyKit/PolicyKit.conf.multi-save
    fi
    if [[ -x /opt/userful/bin/umx-storage-update-polkit-config.py ]]; then
        /opt/userful/bin/umx-storage-update-polkit-config.py /etc/PolicyKit/PolicyKit.conf
        chmod a+r /etc/PolicyKit/PolicyKit.conf
    fi
fi

#
# Update fdi of the storage methods for Mount
#if [ -f /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi ]; then # FC6
#	sed -i -e "s/hal-storage-mount/userful-storage-mount/g" /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi
#fi

##
## Create softlink for Mount function
## TODO:
##  - Path is different for the 64bit OS
LIB=$(check_arch)

if [ -f /usr/libexec/hal-storage-mount ]; then # FC6
	ln -sf /opt/userful/bin/userful-storage-mount /usr/libexec/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/libexec/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/libexec/userful-storage-eject

elif [ -f /usr/$LIB/hal/hal-storage-mount ]; then # Kubuntu 7.04, Debian 4.0, SuSE11.0
	ln -sf /opt/userful/bin/userful-storage-mount /usr/$LIB/hal/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/$LIB/hal/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/$LIB/hal/userful-storage-eject

elif [ -f /usr/$LIB/hal/scripts/hal-system-storage-mount ]; then # SLED 10 
	ln -sf /opt/userful/bin/userful-storage-mount /usr/$LIB/hal/scripts/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/$LIB/hal/scripts/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/$LIB/hal/scripts/userful-storage-eject
fi

#
# add userful fdi for the storage device hotplug
#if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then #FC6
#	cp -f /etc/userful/setup/99-userful-storage-policy.fdi /usr/share/hal/fdi/policy/20thirdparty
#fi

#
# Create softlink for Hotplug callback function
if [ -d /usr/$LIB/hal/scripts ]; then #
	ln -sf /opt/userful/bin/multistation-storage-hotplug.sh /usr/$LIB/hal/scripts/multistation-storage-hotplug.sh
fi

