#!/bin/bash
#
#
# Copyright (c) 2002-2007 by Userful Corporation
#
# Name: userful-storage-update-ownership.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#	- Update ownership to $PAM_USER during OPEN_SESSION
#	- Update ownership to root during CLOSE_SESSION
# 	- Unmount every volume assinged to $PAM_USER.
#
# Called from: userful-multiuserdevice-update-ownership.sh
#
# Parameters:
# 	$1: PAM_TTY
# 	$2: PAM_FUNCTION
# 	$3: PAM_USER
###################################################################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

SCREEN_NUM=$1
SCREEN_NUM=${SCREEN_NUM/.*}
ACTION=$2
CURRENT_USER=$3

SCREEN_STR="Srn$SCREEN_NUM.0"

if [ "$ACTION" == "OPEN_SESSION" ]; then
	
	# TODO:
	# 	why do we need this?
	#echo   $CURRENT_USER > /tmp/."$SCREEN_STR".user  

	# TODO: 
	# 	- Do we need to change the ownership?
	# Change the ownership of the devices that assinged to SCREEN_NUM to CURRENT_USER 
	for BLOCK_DEV in `grep $SCREEN_STR /etc/multiuserdevices | awk '{print $2}'`
	do
		echo "`date +"%b %d %T"` $ProgramName:(Login) Assign $BLOCK_DEV to $CURRENT_USER, DISPLAY=$SCREEN_NUM" >> $logfile
		chown $CURRENT_USER $BLOCK_DEV 2> /dev/null
        chmod 600 $BLOCK_DEV 2> /dev/null

		chown $CURRENT_USER $BLOCK_DEV[1-9] > /dev/null 2>&1 # This is for flash device
        chmod 600 $BLOCK_DEV[0-9] 2> /dev/null
	done

	# Change the permission of shared devices  
	for BLOCK_DEV in `grep Shared_by_All_Stations /etc/multiuserdevices | awk '{print $2}'`
	do
        chmod a+rw $BLOCK_DEV 2> /dev/null
        chmod a+rw $BLOCK_DEV[0-9] 2> /dev/null
	done

	# update ownership of assigned devices
	#grep "$SCREEN_STR" /etc/multiuserdevices > /tmp/dm-assigned-storage.$SCREEN_NUM
	#
	#while read DEV_STR ; do
	#	DEV_NAME=`echo $DEV_STR | awk '{print $2}'`
	#	chown $3 $DEV_NAME
	#done < /tmp/dm-assigned-storage.$SCREEN_NUM
	#
	#rm -f /tmp/dm-assigned-storage.$SCREEN_NUM

    # TODO:
    #   may need to do something here for user session startup for KDE.
    #   maybe possible to do something here for gdm too instead of /usr/share/gnome/default.session
    #   For now nothing to do for storage device

elif [ "$ACTION" == "CLOSE_SESSION" ]; then

    if [ "$CURRENT_USER" != "root" ]; then

    ###
    # Unmount any volume mounted by CURRENT_USER
    ###
    CURRENT_USER_ID=`id -u $CURRENT_USER`

    for MOUNTED_DEV in `mount | grep "uid=$CURRENT_USER_ID" | awk '{print $1}'`
    do
        if [ "$MOUNTED_DEV" == "/dev/fd0" ]; then
            # Internal floppy doesn't have volume.. Weird..
            TARGET_UDI=`hal-find-by-property --key "block.device" --string "$MOUNTED_DEV"`
            dbus-send --system --dest=org.freedesktop.Hal $TARGET_UDI org.freedesktop.Hal.Device.Volume.Unmount array:string:
		    echo "`date +"%b %d %T"` $ProgramName:(Logout) Unmount $MOUNTED_DEV" >> $logfile

        else
            # Need to find volume for the current block.device and unmount it
            for TARGET_UDI in `hal-find-by-property --key "block.device" --string "$MOUNTED_DEV"`
            do
                INFO_CATEGORY=`hal-get-property --udi $TARGET_UDI --key "info.category"`
                if [ "$INFO_CATEGORY" == "volume" ]; then

                    IS_DISC=`hal-get-property --udi $TARGET_UDI --key "volume.is_disc"`
                    if [ "$IS_DISC" == "true" ]; then
                        dbus-send --system --print-reply --type=method_call \
                                --dest=org.freedesktop.Hal $TARGET_UDI org.freedesktop.Hal.Device.Volume.Eject array:string:
		                echo "`date +"%b %d %T"` $ProgramName:(Logout) Eject $MOUNTED_DEV" >> $logfile
                    else
                        dbus-send --system --print-reply --type=method_call \
                                --dest=org.freedesktop.Hal $TARGET_UDI org.freedesktop.Hal.Device.Volume.Unmount array:string:
		                echo "`date +"%b %d %T"` $ProgramName:(Logout) Unmount $MOUNTED_DEV" >> $logfile
                    fi
                fi
            done
        fi
    done

	# Change ownership back to root
	for BLOCK_DEV in `grep $SCREEN_STR /etc/multiuserdevices | awk '{print $2}'`
	do
		chown root $BLOCK_DEV
		chown root $BLOCK_DEV[1-9] > /dev/null 2>&1 # This is for flash device
	done

	# TODO:
	#	Why do we need this?
	#rm -f /tmp/."$SCREEN_STR".user

    fi # "$CURRENT_USER" != "root"
fi
