#!/usr/bin/env python

# Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
# http://www.userful.com/

# submission.py

"""
A dialog to submit debug info to Jason

Arguments: -f file to write responses to

"""

import gtk 
import gtk.glade
import os
import time
import sys
import getopt
#import urllib

class PyGlade:
    glade_filename = 'submission.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/umx-utils/')

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            sys.exit(1)

        widget = self.gtk_glade_xml.get_widget("main_dialog")
        widget.set_icon_from_file(self.find_file("userful-logo.svg"))

        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

        self.file_name = "/dev/stdout"

    def set_file_name(self, f):
        self.file_name = f
        
    def set_error_text (self, text):
        widget = self.gtk_glade_xml.get_widget("error_label")
        #widget.set_text(text)
        text_prefix = "<span foreground=\"red\" weight=\"bold\">"
        text_postfix = "</span>"
        if (len(text) > 256):
            text = text[:255]
        text = text.replace("&", "&amp;")
        text = text.replace("<", "&lt;")
        text = text.replace(">", "&gt;")
        try:
            widget.set_markup(text_prefix + text + text_postfix)
        except:
            widget.set_markup(text_prefix + "server error" + text_postfix)
        return

    def set_key_text (self, text):
        widget = self.gtk_glade_xml.get_widget("activation_key_entry")
        widget.set_text(text)
        return

    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

    ################ CALLBACKS ################

    def quit(self, widget):
        gtk.main_quit()
        sys.exit(1)
        
    def on_submit_button_clicked(self, widget):
        # write it out to a file:
        out_file = None
        if (self.file_name):
            try:
                out_file = file(self.file_name, "w")
            except IOError:
                gtk.main_quit()
                return
        else:
            gtk.main_quit()
            return

        widget = self.gtk_glade_xml.get_widget("email_entry")
        email = widget.get_text()
            
        widget = self.gtk_glade_xml.get_widget("customer_entry")
        customer = widget.get_text()

        widget = self.gtk_glade_xml.get_widget("ticket_entry")
        ticket = widget.get_text()

        widget = self.gtk_glade_xml.get_widget("desc_entry")
        desc_buffer = widget.get_buffer()
        desc = desc_buffer.get_text(desc_buffer.get_start_iter(), desc_buffer.get_end_iter())

        out_file.write("EMAIL=\"" + str(email) + "\"\n")
        out_file.write("CUSTOMER=\"" + str(customer) + "\"\n")
        out_file.write("TICKET=\"" + str(ticket) + "\"\n")
        out_file.write("DETAILS=\"\"\"" + str(desc) + "\"\"\"\n")
        
        out_file.close()
                       
        gtk.main_quit()
        
def usage(msg=''):
    print >> sys.stderr, __doc__
    if msg:
        print >> sys.stderr, msg

def main():

    try:
        optlist, args = getopt.getopt(sys.argv[1:], "hf:", ["help", "file="])
    except getopt.GetoptError:
        # print help information and exit:
        usage("Error in parsing arguments")
        sys.exit(2)


    file_name = "/dev/stdout"

    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o in ("-f", "--file"):
            file_name = a

    PyGlade_ins = PyGlade()

    PyGlade_ins.set_file_name(file_name)
    
    gtk.main()

if __name__ == "__main__":
    main()

