#!/bin/bash

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# find-license.sh

LOG=/dev/null
if [ -n "$DEBUG" ] ; then
    LOG=install-license.out
fi

echo .

SYS_ID=no-sys-id
if [ -f /etc/userful/sys-id ] ; then
    SYS_ID_TMP=`cat /etc/userful/sys-id`
    if [ -n "$SYS_ID_TMP" ] ; then
        SYS_ID=$SYS_ID_TMP
    fi
fi

# parse arguments:
while getopts "c:d:s:t:" flag ; do
    case "$flag" in
        c)
            # a file that we can look at for  
            CONFIG_FILE="$OPTARG"
            ;;
        d)
            # this is the directory the user chose 
            STARTING_POINT="$OPTARG"
            ;;
        s) 
            SAVE_DIR="$OPTARG"
            ;;
        t) 
            TMP_DIR="$OPTARG"
            ;;
        ?)
            usage
            exit 1
            ;;
    esac
done

echo "looking at $STARTING_POINT" >> $LOG

if [ -z "$CONFIG_FILE"  -o ! -f "$CONFIG_FILE" ] ; then
	echo "no config file"
    exit 1
fi

source $CONFIG_FILE

if [ -n "$STARTING_POINT" ] && [ -f "$STARTING_POINT" ] ; then 

    PROVIDED_LICENSE="$STARTING_POINT"

    UNZIP_TMP=/tmp/find-license.sh.$$
    trap "rm $UNZIP_TMP 2>/dev/null" 0

    mkdir -p "$UNZIP_TMP"
    cd "$UNZIP_TMP"


    if [ "$PROVIDED_LICENSE" != "${PROVIDED_LICENSE%.zip}" ] ; then
        # the provided file looks to be a zip file
        unzip "$PROVIDED_LICENSE" -d "$UNZIP_TMP"
    fi
    
    if [ "$PROVIDED_LICENSE" != "${PROVIDED_LICENSE%.tar.bz2}" ] ; then
        # the provided file looks to be a bzip file
        cd "$UNZIP_TMP"
        tar jxf "$PROVIDED_LICENSE"
    fi
    if [ "$PROVIDED_LICENSE" != "${PROVIDED_LICENSE%.tar.gz}" -o "$PROVIDED_LICENSE" != "${PROVIDED_LICENSE%.tgz}" ] ; then
        # the provided file looks to be a gzip file
        cd "$UNZIP_TMP"
        tar zxf "$PROVIDED_LICENSE"
    fi
    if [ "$PROVIDED_LICENSE" != "${PROVIDED_LICENSE%.gz}" ] ; then
        # the provided file looks to be a gzip file
        cd "$UNZIP_TMP"
        gunzip "$PROVIDED_LICENSE" &> /dev/null
    fi

	echo "recursive looking in $UNZIP_TMP" >> $LOG
    exec /usr/share/umx-utils/find-license.sh -d "$UNZIP_TMP" -s "$SAVE_DIR" -c "$CONFIG_FILE" -t "$TMP_DIR"
fi

echo "looking for mac addr files in $STARTING_POINT (not in $SAVE_DIR)" >> $LOG
echo "find \"$STARTING_POINT\" \( \
    -type f  \
    -not -path \"$TMP_DIR*\"   \
    -not -path \"$SAVE_DIR*\"  \
    -iname \"$MAC_COLONS*\" -or \
    -iname \"$MAC_DASHES*\" -or \
    -iname \"$MAC_UNDERS*\" -or \
    -iname \"$SYS_ID*\" \) \
    -exec cp -avr "{}" \"$SAVE_DIR\" \; " >> $LOG

find "$STARTING_POINT" \( \
    -type f  \
    -not -path "$TMP_DIR*"   \
    -not -path "$SAVE_DIR*"  \
    -iname "$MAC_COLONS*" -or \
    -iname "$MAC_DASHES*" -or \
    -iname "$MAC_UNDERS*" -or \
    -iname "$SYS_ID*" \) \
    -exec cp -avr "{}" "$SAVE_DIR" \;  >> $LOG 2>&1

echo "looking for zip files in $STARTING_POINT" >> $LOG
#echo "find $STARTING_POINT -type f -not -path $TMP_DIR -exec /usr/share/umx-utils/find-license.sh -d \{\} -s $SAVE_DIR -c $CONFIG_FILE  -t $TMP_DIR \; -name *.zip -or -name *.gz -or   -name *.tgz -or  -name *.bz2"

find "$STARTING_POINT" \( -type f   -not -path "$TMP_DIR*"   -not -path "$SAVE_DIR*"  -iname "*.zip" -or  -iname "*.gz" -or  -iname "*.tgz" -or -iname "*.bz2" \) -exec /usr/share/umx-utils/find-license.sh -d "{}" -s "$SAVE_DIR" -c "$CONFIG_FILE"  -t "$TMP_DIR" \; 

exit 0
