#!/bin/bash
#
#   userful-dm.sh
#
#   This is a simple Display Manager using xkeepalive and handles "auto"
#   and "remote" login sessions. Local login sessions are handled by general
#   Display Manager such as GDM and XDM.
#
#   Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
#   Jason Kim <jason@userful.com>
#
# Called from: dm-start-display-manager.sh
# Call: remote-login.sh, auto-login.py

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
LOGIN_TYPE=$1
KEEPALIVE=/opt/userful/bin/keepalive

echo "`date +"%b %d %T"` [$ProgramName]: Starting Userful's simple Display Manager. This is a Master process..." >> $logfile

# find the number of station
# /etc/X11/stations - number of available video heads
# /etc/stations - number from the license key
if [ -f /etc/X11/stations ]; then
    ALL_STATIONS=`cat /etc/X11/stations`
else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unable to find /etc/X11/stations" >> $logfile
    exit 1
fi

if [ -f /etc/stations ]; then
    LICENSED_STATIONS=`cat /etc/stations`

    if [ $LICENSED_STATIONS -ge $ALL_STATIONS ]; then
	    STATIONS_NO=$ALL_STATIONS
    else
	    STATIONS_NO=$LICENSED_STATIONS
    fi

else
	STATIONS_NO=$ALL_STATIONS
fi

# delete all pid file for userful-usbinput-config (Press F-Key program)
rm -f /var/run/pid.kbdlink*

if [[ ! -d /var/log/dm ]]; then
    mkdir /var/log/dm
fi

if [ "$LOGIN_TYPE" == "auto" -o "$LOGIN_TYPE" == "remote" ]; then

    # Start auto or remote login for each station
    for (( N=0 ; N < $STATIONS_NO ; N++ )) ;  do

        #Backup log file and delete log files older than 30 days
	    LOGIN_LOG="$LOGIN_TYPE-login-$N.log"
	    mv --backup=numbered /var/log/dm/$LOGIN_LOG /var/log/dm/$LOGIN_LOG.old
	    find /var/log/dm/ -name "$LOGIN_LOG.old*" -mtime +30 -exec rm -f \{\} \;

        echo "`date +"%b %d %T"` [$ProgramName]: Starting slave Display Manager for DISPLAY=:$N" >> $logfile
        if [[ "$LOGIN_TYPE" == "auto" ]]; then
	        $KEEPALIVE /opt/userful/bin/$LOGIN_TYPE-login.py :$N >> /var/log/dm/$LOGIN_LOG 2>&1 &
        else
	        $KEEPALIVE /opt/userful/bin/$LOGIN_TYPE-login.sh :$N >> /var/log/dm/$LOGIN_LOG 2>&1 &
        fi
        sleep 2

    done

else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unsupport login type: $LOGIN_TYPE" >> $logfile
    exit 1
fi

wait
