#!/bin/bash
#
# Copyright (c) 2004-2006 by Userful Corporation
#
# Name: unlink-kbd.sh
# Author: Jason Kim
# Description:
#   This script runs GUI for kbd-assignment in respond to Ctrl-Alt-Break.
# $1: screenNumber
############################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
UNLINK=0
DISPLAYNUM=
SCREENNUM=
CURRENTDM=
LOCK_FILE=/tmp/unlink-kbd.lock

##########
# usage()
##########
function usage()
{
    echo
    echo "Usage: $0 <Screen Number>"
    echo
    exit 1
}

#-------------------
# Start here...
#-------------------
# 
if [[ -f /etc/userful/dm.conf ]]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi 
if [ "$CTRLALTBREAK" == "disable" ]; then
	echo "`date +"%b %d %T"` $ProgramName: Ctrl-Alt-Break is disabled." >> $logfile
	exit 0
fi

# This is bug fix for locale problem in Educational Linux
if [[ -f /etc/default/locale ]]; then
    echo "`date +"%b %d %T"` [$ProgramName]: source locale" >> $logfile
    source /etc/default/locale 2>> $logfile
    while read line; do
        VARS_NAME=`echo $line | awk -F'=' '{print $1}'`
        export $VARS_NAME >> $logfile
    done < /etc/default/locale

    if [[ -f /etc/bash.bashrc ]]; then
        source /etc/bash.bashrc
    fi
    if [[ -f /etc/profile ]]; then
        source /etc/profile
    fi

    if [[ -f /root/.bashrc ]]; then
        source /root/.bashrc
    fi
    if [[ -f /root/.profile ]]; then
        source /root/.profile
    fi
fi

# receive only one argument(screenNum).  
[[ $# -ne 1 ]] && usage
SCREENNUM=$1

if [[ $SCREENNUM -lt 10 ]]; then
    DISPLAYNUM="0$SCREENNUM"
else
    DISPLAYNUM=$SCREENNUM
fi

if [[ -f /opt/userful/bin/xkeepalive ]]; then
    KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [[ -f /opt/userful/bin/keepalive ]]; then
    KEEPALIVE="/opt/userful/bin/keepalive"
else
	echo "`date +"%b %d %T"` $ProgramName: Unable to find KEEPALIVE." >> $logfile
	exit 1
fi

# avoid multiple executions of unlink-kbd.sh at the same time
if [[ -e $LOCK_FILE ]]; then
	exit 1
fi
: > $LOCK_FILE
rm -f /etc/usbinput.tmp

# We need to set environment variables for language translation. ($LANG)
# This could be different for each distro.
# FC4
[[ -f /etc/profile.d/lang.sh ]] && source /etc/profile.d/lang.sh

if [[ -e /etc/usbinput ]]; then
	while read USBINPUT; do
		# find devices that have same screen number, then unconfigure them
    	if echo $USBINPUT | grep "Srn#=$DISPLAYNUM" > /dev/null; then
			if [[ ${USBINPUT:1:1} -eq 1 ]]; then  # If the current device is configured
	    		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
			fi
    	fi
    	echo $USBINPUT >> /etc/usbinput.tmp
	done < /etc/usbinput

	# update /etc/usbinput
	rm -f /etc/usbinput
	cp -f /etc/usbinput.tmp /etc/usbinput

	# update /etc/X11/Xinput/configstat
	/opt/userful/bin/make-config-file -r
else
	/opt/userful/bin/make-config-file -r
fi

# Check Mandatory device
if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
    /opt/userful/bin/umx-mandatory-dev-refresh.sh
fi

# find current display manager
if [ -e /etc/userful/currentdm ]; then
   	source /etc/userful/currentdm
	if [ -z "$CURRENTDM" ]; then
		CURRENTDM=gdm
	fi
fi

echo "`date +"%b %d %T"` $ProgramName: Unlink keyboard on DISPLAY=:$SCREENNUM, LANG=$LANG" >> $logfile

# check if GUI for kbd-assignment exists on the $SCREENNUM display. 
if [ ! -e /var/run/pid.kbdlink$SCREENNUM -o \
	 ! -d /proc/`cat /var/run/pid.kbdlink$SCREENNUM` ]; then

	if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
		/opt/userful/bin/checkGrabKeyboard -display :$SCREENNUM
		RET=$?

		if [ $RET -eq $TRUE ]; then
			#echo "unlink-kbd.sh  kill login-server" >> $logfile
			kill `cat /var/run/pid.login-server$SCREENNUM`
		else
			#echo "unlink-kbd.sh  start GUI" >> $logfile
			/opt/userful/bin/userful-usbinput-config -display :$SCREENNUM -r &
		fi
	else
		#echo "unlink-kbd.sh  start GUI" >> $logfile
		/opt/userful/bin/userful-usbinput-config -display :$SCREENNUM -r &
	fi
	sleep 0.5
else
	#echo "unlink-kbd.sh  GUI is exist already.." >> $logfile
	:
fi

# re-initialize USBConfigDaemon
if pgrep USBConfigDaemon > /dev/null 2>&1; then
    #pkill USBConfigDaemon
	:
else
	if [ -z "$CURRENTDM" ]; then
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon &
	else
		$KEEPALIVE /opt/userful/bin/USBConfigDaemon -dm $CURRENTDM &
	fi
fi

# re-initialize kbd-daemon
if pgrep kbd-daemon > /dev/null 2>&1; then
  	pkill kbd-daemon
else
    $KEEPALIVE /opt/userful/bin/kbd-daemon 2>>/var/log/kbd-daemon.log &
fi

# re-initialize mse-daemon
if pgrep mse-daemon > /dev/null 2>&1; then
   	pkill mse-daemon
else
    $KEEPALIVE /opt/userful/bin/mse-daemon 2>>/var/log/mse-daemon.log &
fi

# send signal to userful-usbinput-config
#echo "unlink-kbd.sh  send signal HUP to GUI " >> $logfile
/usr/bin/killall -s HUP userful-usbinput-config

rm -f /etc/usbinput.tmp
rm -f  $LOCK_FILE
