#!/bin/bash
#
# umx-block-device-change.sh
#
# Copyright (c) 2005-2006 by Userful Corporation
#
#  This script is called from udev rule in 99-userful-hotplug.rules when a floppy disk 
#  is inserted(Not drive). This will change the ownership of the block device.
#
# TODO:
#  - Test with USB flash device
#  - Test with CDROM

logfile="/var/log/userful-start.log"

#DEBUG
#env >> $logfile

# Check argument
if [ x == x"$1" ]; then
    echo "`date +"%b %d %T"` umx-block-device-change.sh: No arguments received." >>  $logfile
fi
TARGET_DEV=$1

for TARGET_UDI in $(hal-find-by-property --key "block.device" --string "$TARGET_DEV")
do
    INFO_SCREEN=$(hal-get-property --udi $TARGET_UDI --key "info.screen")

    # Block device should have info.screen in hal
    if [ x == x"$INFO_SCREEN" ]; then
        continue
    fi

    # For a 'shared' device, add rw permission for everybody
    if [ "shared" == "$INFO_SCREEN" ]; then
        echo "`date +"%b %d %T"` umx-block-device-change.sh: $TARGET_DEV is shared device." >>  $logfile
        chmod a+rw $TARGET_DEV
	    continue
    fi

    # Check /etc/startat
    if [ -e /etc/startat ]; then
        STARTAT=$(cat /etc/startat)
    fi
    if [ x == x"$STARTAT" ]; then
        STARTAT="1"
    fi

    # Figure station #
    STATIONNUM=$(($STARTAT+$INFO_SCREEN))
    
    # Find user for TARGET_DEV and update ownership
    if [ -e /opt/userful/locks/stationusername$STATIONNUM ]; then
        STATIONUSER=$(cat /opt/userful/locks/stationusername$STATIONNUM)
        echo "`date +"%b %d %T"` umx-block-device-change.sh: $TARGET_DEV is assigned to $STATIONUSER" >>  $logfile
        chown $STATIONUSER $TARGET_DEV
    fi
done
