#!/bin/bash
#
# dm-config-display-manager.sh
#
#    Configure the display manager based on the X type, DM and Distro.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# $1: CURRENTXTYPE
# $2: CURRENTDM

# set OSNAME, OSVER
if [ ! -f /etc/userful/os-info ]; then
	/opt/userful/bin/dm-check-os.sh
fi
source /etc/userful/os-info

# single X
if [ "$1" = "single" ]; then
	case "$OSNAME" in
		"fedora"|"redhat"|"centos"|"freedows" ) ### Fedora, Redhat, CentOS ###
			if [ "$2" = "gdm" ]; then 
				if [ -f /etc/X11/gdm/gdm.conf.multi-save ]; then
					cp -f /etc/X11/gdm/gdm.conf.multi-save  /etc/X11/gdm/gdm.conf
				elif [ -f /etc/gdm/custom.conf.multi-save ]; then
					cp -f /etc/gdm/custom.conf.multi-save  /etc/gdm/custom.conf
				else
					cp -f /etc/X11/gdm/factory-gdm.conf  /etc/X11/gdm/gdm.conf.multi-save
					cp -f /etc/X11/gdm/factory-gdm.conf  /etc/X11/gdm/gdm.conf
				fi
			elif [ "$2" = "kdm" ]; then
				cp -f /etc/X11/xdm/kdmrc.multi-save  /etc/X11/xdm/kdmrc
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			elif [ "$2" = "xdm" ]; then
				cp -f /etc/X11/xdm/xdm-config.multi-save  /etc/X11/xdm/xdm-config
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			else
				echo "Error: Unsupported Display Manager"
				echo "Script can't be reached here"
			fi
			;;

		"suse"|"novell"|"jds" ) ### SuSE, Novell, JDS
			if [ "$2" = "gdm" ]; then
				if [ -e /etc/opt/gnome/gdm ]; then

                    if [[ -e /etc/opt/gnome/gdm/gdm.conf.multi-save ]]; then
					    cp -f /etc/opt/gnome/gdm/gdm.conf.multi-save  /etc/opt/gnome/gdm/gdm.conf
                    fi
                    if [[ -e /etc/opt/gnome/gdm/custom.conf.multi-save ]]; then
					    cp -f /etc/opt/gnome/gdm/custom.conf.multi-save  /etc/opt/gnome/gdm/custom.conf
                    fi
				fi	
				if [ -e /etc/sun-release ] && [ -e /etc/X11/gdm ]; then
					cp -f /etc/X11/gdm/gdm.conf.multi-save /etc/X11/gdm/gdm.conf 
				fi
                if [[ -e /etc/gdm/custom.conf.multi-save ]]; then
				    cp -f /etc/gdm/custom.conf.multi-save  /etc/gdm/custom.conf
                fi

			elif [ "$2" = "kdm" ]; then
				cp -f /etc/opt/kde3/share/config/kdm/kdmrc.multi-save  /etc/opt/kde3/share/config/kdm/kdmrc
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			elif [ "$2" = "xdm" ]; then
				cp -f /etc/X11/xdm/xdm-config.multi-save  /etc/X11/xdm/xdm-config
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			else
				echo "Error: Unsupported Display Manager"
				echo "Script can't be reached here"
			fi
			;;

		"mandrake" ) ### Mandrake ###
			if [ "$2" = "gdm" ]; then
				cp -f /etc/X11/gdm/gdm.conf.multi-save  /etc/X11/gdm/gdm.conf
			elif [ "$2" = "kdm" ]; then
				cp -f /usr/share/config/kdm/kdmrc.multi-save /usr/share/config/kdm/kdmrc
				cp -f /etc/X11/xdm/Xservers.mulit-save  /etc/X11/xdm/Xservers
			elif [ "$2" = "xdm" ]; then
				cp -f /etc/X11/xdm/xdm-config.multi-save  /etc/X11/xdm/xdm-config
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			else
				echo "Error: Unsupported Display Manager"
				echo "Script can't be reached here"
			fi
			;;

		"xandros"|"mepis" )
			if [ "$2" = "kdm" ]; then
				cp -f /etc/kde3/kdm/kdmrc.multi-save  /etc/kde3/kdm/kdmrc
				cp -f /etc/kde3/kdm/Xservers.multi-save  /etc/kde3/kdm/Xservers
				cp -f /etc/X11/xdm/Xservers.multi-save  /etc/X11/xdm/Xservers
			else
				echo "Error: Unsupported Display Manager"
				echo "Script can't be reached here"
			fi
			;;
		
		"ubuntu"|"linspire"|"debian"|"freespire"|"morphix" )
			if [ "$2" = "gdm" ]; then # gdm
				if [ -f /etc/gdm/gdm-cdd.conf ]; then
					cp -f /etc/gdm/gdm-cdd.conf.multi-save  /etc/gdm/gdm-cdd.conf
				elif [ -f /etc/gdm/gdm.conf-custom ]; then
					cp -f /etc/gdm/gdm.conf-custom.multi-save  /etc/gdm/gdm.conf-custom
				elif [ -f /etc/gdm/gdm.conf ]; then
					cp -f /etc/gdm/gdm.conf.multi-save  /etc/gdm/gdm.conf
				fi
			elif [ "$2" = "kdm" ]; then
				cp -f /etc/kde3/kdm/kdmrc.multi-save  /etc/kde3/kdm/kdmrc
        	else
				echo "Error: Unsupported Display Manager"
				echo "Script can't be reached here"
        	fi
			;;

		* )
			echo "Unsupported Linux system"
			exit 1
			;;
	esac

# Multi X
elif [ "$1" = "multi" ]; then
	#
	# need to handle system upgrading and uninstalling of DM

	# Availble video heads
	ALL_HEAD=`cat /etc/X11/stations`
	# Station number
	S_NUM=`cat /etc/stations`

	if [ $S_NUM -ge $ALL_HEAD ]; then
		STATIONSNO=$ALL_HEAD
	else
		STATIONSNO=$S_NUM
	fi
	echo "`date +"%b %d %T"` $ProgramName: Station-#-from-License-key=$S_NUM, Available-Station-#=$ALL_HEAD" >> $logfile

	if [ "$2" = "gdm" ]; then  ### GDM ###

		case "$OSNAME" in
			"fedora"|"redhat"|"centos"|"mandrake"|"freedows" )
				if [ -f /etc/X11/gdm/gdm.conf ]; then
					DMCONFIGPATH="/etc/X11/gdm/gdm.conf"
				elif [ -f /etc/gdm/custom.conf ]; then
					DMCONFIGPATH="/etc/gdm/custom.conf"
				fi

				;;

			"suse"|"novell"|"jds" )
				if [ -e /etc/opt/gnome/gdm/gdm.conf ]; then
					DMCONFIGPATH="/etc/opt/gnome/gdm/gdm.conf"
				elif [ -e /etc/opt/gnome/gdm/custom.conf ]; then
					DMCONFIGPATH="/etc/opt/gnome/gdm/custom.conf"
				elif [ -e /etc/sun-release -a -e /etc/X11/gdm ]; then
					DMCONFIGPATH="/etc/X11/gdm/gdm.conf"
				elif [ -e /etc/gdm/custom.conf ]; then
					DMCONFIGPATH="/etc/gdm/custom.conf"
				fi
				;;

			"ubuntu"|"linspire"|"debian"|"freespire"|"morphix" )
				if [ -f /etc/gdm/gdm-cdd.conf ]; then
					DMCONFIGPATH="/etc/gdm/gdm-cdd.conf"
				elif [ -f /etc/gdm/gdm.conf-custom ]; then
					DMCONFIGPATH="/etc/gdm/gdm.conf-custom"
				elif [ -f /etc/gdm/gdm.conf ]; then
					DMCONFIGPATH="/etc/gdm/gdm.conf"
				fi
				;;

			* )
				echo "Unsupported Linux System"
				;;
		esac

		rm -f $DMCONFIGPATH.multi
		/opt/userful/bin/dm-config-gdm.sh "$DMCONFIGPATH"

		# FC5 has different config name
		#if [ "$OSNAME" == "novell" -a "$OSVER" == "10" ] || \
		#	[ "$OSNAME" == "fedora" -a "$OSVER" == "5" ] || \
		#	[ "$OSNAME" == "ubuntu" -a "$OSVER" == "5.10" ] || \
		#	[ "$OSNAME" == "ubuntu" -a "$OSVER" == "6.06" ]; then
		#	rm -f $DMCONFIGPATH.multi
		#	/opt/userful/bin/dm-config-gdm.sh "$DMCONFIGPATH"
		#else
		#	cp -f $DMCONFIGPATH.multi $DMCONFIGPATH
		#fi
		
		# update gdm.conf according to the number of station
		for ((i = 0; i < $STATIONSNO; i++))
		do
			sed -i -e "s/^#$i=Login/$i=Login/g" $DMCONFIGPATH
		done

		XSERVERSPATH="/etc/X11/xdm/Xservers"
		cp -f $XSERVERSPATH.multi $XSERVERSPATH

	elif [ "$2" = "kdm" ]; then  ### KDM ###
		case "$OSNAME" in
			"fedora"|"redhat"|"centos" )
				DMCONFIGPATH="/etc/X11/xdm/kdmrc"
				XSERVERSPATH="/etc/X11/xdm/Xservers"
				;;

			"mandrake" )
				DMCONFIGPATH="/usr/share/config/kdm/kdmrc"
				XSERVERSPATH="/etc/X11/xdm/Xservers"
				;;

			"suse"|"novell"|"jds" )
				DMCONFIGPATH="/etc/opt/kde3/share/config/kdm/kdmrc"
				XSERVERSPATH="/etc/X11/xdm/Xservers"
				;;
			"xandros"|"mepis"|"ubuntu"|"debian" )
				DMCONFIGPATH="/etc/kde3/kdm/kdmrc"
				XSERVERSPATH="/etc/kde3/kdm/Xservers"
				;;

			* )
				echo "Unsupported Linux System"
				;;
		esac

        if [ -f $XSERVERSPATH ]; then
			cp -f $DMCONFIGPATH.multi $DMCONFIGPATH
			cp -f $XSERVERSPATH.multi $XSERVERSPATH

			# update Xserver
			if [ -n "$XSERVERSPATH" ]; then
				for ((i = 0; i < $STATIONSNO; i++))
				do
					sed -i -e "s/^#:$i local/:$i local/g" $XSERVERSPATH
				done
			fi
		fi

		rm -f $DMCONFIGPATH.multi
		/opt/userful/bin/dm-config-kdm.sh "$DMCONFIGPATH"

		# if system has newer version of KDM, update kdmrc.
		KDMSERVERS="StaticServers=:0"
		if grep StaticServers $DMCONFIGPATH > /dev/null; then
			for ((i = 1; i < $STATIONSNO; i++))
			do
				KDMSERVERS="$KDMSERVERS,:$i"
			done

			sed -i -e "s/^StaticServers.*/$KDMSERVERS/g" $DMCONFIGPATH
		fi

	elif [ "$2" = "xdm" ]; then  ### XDM ###
		DMCONFIGPATH="/etc/X11/xdm/xdm-config"
		XSERVERSPATH="/etc/X11/xdm/Xservers"

		cp -f $DMCONFIGPATH.multi $DMCONFIGPATH
		cp -f $XSERVERSPATH.multi $XSERVERSPATH

		for ((i = 0; i < $STATIONSNO; i++))
		do
			sed -i -e "s/^#:$i local/:$i local/g" $XSERVERSPATH
		done

	else
		echo "Error: Unsupported Display Manager"
		echo "Script can't be reached here"
	fi

else
	echo "Error: Unsupported X type"
	echo "Script can't be reached here"
fi

