#!/usr/bin/env python

""" Start auto login session as a user specified in dm.conf

auto-login.py is a python program to run a User session based on dm.conf. It is called from
userful-dm.sh and fork a child process to run auto-start-session.sh, then wait the child process.
In the child process, it change the process USER ID and exec auto-start-session.sh.

Called From: userful-dm.sh
Calling:

Parameters: DISPLAY variable ( ex: :0 )

Copyright (c) 2002-2007 Userful Corporation. All right reserved.

Change Log:
    * Nov 30 2007
      - The first writing with basic functionality.

"""

import sys, os, pwd, time
import ConfigParser

CONFIG_FILE = "/etc/userful/dm.conf"

## Check arguments
argc=len(sys.argv)
program_name=os.path.basename(sys.argv[0])

## TODO: Need to remove
print argc

##
## Parse config file, /etc/userful/dm.conf
config_file = ConfigParser.ConfigParser()
try:
    config_file.read(CONFIG_FILE)
except:
    print "Invalid config file"
    sys.exit()

##
## TODO:  Need to remove
print config_file.sections()

## Check debug mode
if config_file.has_option("debug", "DEBUG"):
    debug = config_file.get("debug", "DEBUG")
    ##
    ## TODO:  Need to remove
    print debug
else:
    debug = "false"


###########
#  usage()
###########
# TODO:
#   - Need to write correct usage 
def usage():
    print """Usage: %s <DISPLAY>

    OPTIONS:
        DISPLAY  - Display Number (:#)""" % program_name
    sys.exit()
# End of usage()

## auto-login.py should receive one argument, DISPLAY.
if argc != 2:
    usage()
else:
    ##
    ## TODO:  Need to remove
    print sys.argv[1]
    try:
        screen_num = int(sys.argv[1][1:])
    except:
        usage()

if debug == "true":
    print "{DEBUG} %s %s screen_num=%d" % (sys.argv[0], sys.argv[1], screen_num)

## 
## TODO:
##  - If input configuration is static, don't run "press-Fkey" GUI.
if config_file.has_option("input", "DEVCONF"):
    devconf = config_file.get("input", "DEVCONF")
else:
    devconf = "dynamic"

## TODO:  Need to remove
print devconf

# Create /etc/usbinput file if it doesn't exist
if not os.path.exists("/etc/usbinput"):
    os.spawnl(os.P_WAIT, '/opt/userful/bin/make-config-file', '-r')

##
## TODO:
##   - Should check/update mandatory devices

is_configured = False

# Check if the current station has been configured only if the input configuration is dynamic.
if devconf == "dynamic":
    if os.path.exists("/etc/usbinput"):

        screen_str = "Srn#=%2.2d" % screen_num

        f = open('/etc/usbinput', 'r')
        for line in f:
            ## TODO:  Need to remove
            print "{DEBUG} inside of for loop"
            if line.find("kbd") > 0 and line.find(screen_str) > 0:
                if line[0:2] == "D1": # Configured
                    if debug == "true":
                        print "[%s] DISPLAY :%d configured with a keyboard." % (program_name, screen_num)
                    is_configured = True
                    break

        f.close()

    else:
        # No /etc/usbinput
        print "[%s] /etc/usbinput is not available." % program_name

## TODO:  Need to remove
print os.environ

# TODO:
#   - Need to set DISPLAY variable before starting either a session or "Press Fkey" program.
#   - Need to find out the user for this station and run program as the user. Default is root
#   - Need to find out the program to run for this station. Default is xterm
# Set DISPLAY variable before starting any session program
os.putenv("DISPLAY", sys.argv[1])
os.putenv("PAM_TTY", sys.argv[1])

########################
# Start auto session 
# Depend on the keyboard configuration, run "Press F-key" program or User session.
########################
if is_configured or devconf == "static":

    if devconf == "static":
        print "[%s] Input configuration is static." % program_name
    else:
        print "[%s] DISPLAY :%d configured, run a user session program" % (program_name, screen_num)

    ##
    ## TODO:
    ##  - Station number can be started from any number like DiscoverStation using startat.
    #  Find user to run the session program
    station_user = "STN%d_USER" % (screen_num + 1)
    if debug == "true":
        print "[%s] station_user = %s" % (program_name, station_user)

    if config_file.has_option("auto", station_user):
        user_name = config_file.get("auto", station_user)
    else:
        user_name = "root"

    ##
    ## Check whether user_name exist
    try:
        user_info = pwd.getpwnam(user_name)
    except:
        # getpwnam() failed
        print "[%s] %s is not a valid user name. Use root instead" % (program_name, user_name)

        user_name = "root"
        user_info = pwd.getpwnam(user_name)

    if debug == "true":
        print "[%s] user_name = %s" % (program_name, user_name)

    ## Check the program to run for this station
    station_run = "STN%d_RUN" % (screen_num + 1)
    if debug == "true":
        print "[%s] station_run = %s" % (program_name, station_run)

    if config_file.has_option("auto", station_run):
        appToRun = config_file.get("auto", station_run)
    else:
        appToRun = "/opt/userful/bin/auto-start.sh"

    if debug == "true":
        print "[%s] Application to run = %s" % (program_name, appToRun)

    ## Run target program        
    ## "dst" session is not implemented yet.
    if appToRun == "xterm":

        print "[%s] Run %s session on DISPLAY :%d" % (program_name, appToRun, screen_num)
        os.execlp( "xterm", "xterm", "-display", sys.argv[1] )

    else:

        print "[%s] Run %s session on DISPLAY :%d" % (program_name, appToRun, screen_num)

        if not os.path.exists(appToRun):
            print "[%s] %s doesn't exist. Run xterm instead." % (program_name, appToRun)
            os.execlp( "xterm", "xterm", "-display", sys.argv[1] )

        try:
            ret = os.fork()
        except:
            ## Failed to fork child process
            ## exec terminal program as session
            print "[EE] %s: Can't fork child process for DISPLAY :%d" % (program_name, screen_num)
            time.sleep(2)
            sys.exit()

        if ret == 0:

            ## Child process
            if user_name is not "root":

                # Delay seconds before running multistation-devices-update-ownership.sh
                time.sleep(3)

                # Update the ownership of X socket
                X_socket = "/tmp/.X11-unix/X%d" % screen_num
                os.chown(X_socket, user_info[2], -1)

                # Run /opt/userful/bin/multistation-devices-update-ownership.sh
                os.putenv("PAM_USER", user_name)
                os.putenv("PAM_FUNCTION", 'OPEN_SESSION')
                os.spawnl(os.P_WAIT, '/opt/userful/bin/multistation-devices-update-ownership.sh')

                # update USER ID of current process
                os.setuid(user_info[2])

            time.sleep(1)
            os.execle( "/opt/userful/bin/auto-start-session.sh", "auto-start-session.sh", str(screen_num), appToRun, \
                      {"USER":user_info[0], "HOME":user_info[5], "SHELL":user_info[6], "DISPLAY":sys.argv[1]})
        elif ret > 0:
            ## Parent: wait for child process
            os.wait()

else:
    print "[%s] Screen %d is NOT configured, start \"Press F-key\" program" % (program_name, screen_num)
    os.execl("/opt/userful/bin/userful-usbinput-config", "userful-usbinput-config", "-display", sys.argv[1])

print "Shouldn't be reached this far..   End of program"
