package org.herac.tuxguitar.song.models.effects;

public class HarmonicEffect {
	public static final String KEY_NATURAL = "N.H";
	
	public static final String KEY_ARTIFICIAL = "A.H";
	
	public static final String KEY_TAPPED = "T.H";
	
	public static final String KEY_PINCH = "P.H";
	
	public static final String KEY_SEMI = "S.H";
	
	public static final int TYPE_NATURAL = 1;
	
	public static final int TYPE_ARTIFICIAL = 2;
	
	public static final int TYPE_TAPPED = 3;
	
	public static final int TYPE_PINCH = 4;
	
	public static final int TYPE_SEMI = 5;
		
	public static final int MIN_ARTIFICIAL_OFFSET = -24;
	
	public static final int MAX_ARTIFICIAL_OFFSET = 24;
	
	public static final int MAX_TAPPED_OFFSET = 24;
	
	private int type;
	
	private int data;
	
	public HarmonicEffect(int type){
		this(type,0);
	}
	
	public HarmonicEffect(int type,int data){
		this.type = type;
		this.data = data;
	}
	
	public int getData() {
		return data;
	}

	public void setData(int data) {
		this.data = data;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}
	
	public boolean isNatural(){
		return (this.type == TYPE_NATURAL);
	}

	public boolean isArtificial(){
		return (this.type == TYPE_ARTIFICIAL);
	}	

	public boolean isTapped(){
		return (this.type == TYPE_TAPPED);
	}	

	public boolean isPinch(){
		return (this.type == TYPE_PINCH);
	}	
	
	public boolean isSemi(){
		return (this.type == TYPE_SEMI);
	}	
	
	public Object clone(){
		HarmonicEffect effect = new HarmonicEffect(this.type,this.data);
		
		return effect;
	}
}
