package org.herac.tuxguitar.song.models.effects;

import org.herac.tuxguitar.song.models.Duration;

public class GraceEffect {

	public static final int TRANSITION_NONE = 0;
	
	public static final int TRANSITION_SLIDE = 1;
	
	public static final int TRANSITION_BEND = 2;	
	
	public static final int TRANSITION_HAMMER = 3;	
	
	private int fret;			
	private int duration;
	private int dynamic;
	private int transition;
	private boolean onBeat;
	private boolean dead;
		
	public GraceEffect(int fret, int duration, int dynamic, int transition, boolean onBeat, boolean dead) {
		this.fret = fret;
		this.duration = duration;
		this.dynamic = dynamic;
		this.transition = transition;
		this.onBeat = onBeat;
		this.dead = dead;
	}

	public boolean isDead() {
		return dead;
	}

	public void setDead(boolean dead) {
		this.dead = dead;
	}

	public int getDuration() {
		return duration;
	}

	public void setDuration(int duration) {
		this.duration = duration;
	}

	public int getDynamic() {
		return dynamic;
	}

	public void setDynamic(int dynamic) {
		this.dynamic = dynamic;
	}

	public int getFret() {
		return fret;
	}

	public void setFret(int fret) {
		this.fret = fret;
	}

	public boolean isOnBeat() {
		return onBeat;
	}

	public void setOnBeat(boolean onBeat) {
		this.onBeat = onBeat;
	}

	public int getTransition() {
		return transition;
	}

	public void setTransition(int transition) {
		this.transition = transition;
	}

	public int getDurationTime(){
		return (int)(((float)Duration.QUARTER_TIME / 16.00 ) * (float)getDuration());
	}
	
	public Object clone(){
		return new GraceEffect(fret,duration,dynamic,transition,onBeat,dead);
	}
}
