package org.herac.tuxguitar.gui.system.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class PluginManager {

	public static final String PROPERTY_PLUGIN_PATH = "plugin.path";
	
	public static final String PROPERTY_PLUGIN_CLASS = "plugin.class";
	
	private static final String LANGUAGE_FOLDER = "lang";

	private List plugins;

	private List pluginItems;
	
	public PluginManager(){
		this.plugins = new ArrayList();
		this.pluginItems = new ArrayList();		
	}
    
	public List getPlugins(){
		return this.plugins;
	}
	
	public List getPluginItems(){
		return this.pluginItems;
	}
	
    /**
     * Load language files from lang folder
     *
     */
    public void loadPlugins(){    	
    	// we need plugin_*.properties files only
    	final FilenameFilter filter = new FilenameFilter() {
    		public boolean accept(File dir, String name) {
    			return (name.indexOf("plugin_") != -1 && name.indexOf(".properties") != -1);
    		}
    	};          
    	// get the files
    	String prefix = TuxGuitarFileUtils.PLUGINS_PREFIX;
    	if(prefix != null){        	
    		File path = new File(prefix);
    		if(path != null && path.exists()){
    			String[] files = path.list(filter);        
    			for(int i = 0;i < files.length;i++){        	        			
    				try {
    					loadPLugin(prefix + File.separator + files[i]);
    				} catch (Exception e) {
    					e.printStackTrace();
    				} catch (Error e) {
    					e.printStackTrace();
    				}        					
    			}
    		}
    	}		       
    }    
    
    private void loadPLugin(String pluginProperties) throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException{    	
    	try{
    		Properties properties = new Properties();    		
    		properties.load(new FileInputStream(pluginProperties));
			
    		String pluginPath = properties.getProperty(PROPERTY_PLUGIN_PATH,new String());
    		String pluginClass = properties.getProperty(PROPERTY_PLUGIN_CLASS,new String());
			
    		File file = new File(pluginPath);
		
    		if(file != null && file.exists()){		
    			ClassLoader loader = new URLClassLoader(new URL[]{ new File(pluginPath).toURL() },getClass().getClassLoader());	
    			if(loader != null){
    				Class loadedClass = loader.loadClass(pluginClass);
    				if(loadedClass != null){
    					Object object = loadedClass.newInstance();
    					if(object instanceof TGPlugin){		
    						TGPlugin plugin = (TGPlugin)object;
    						plugins.add(plugin);
    						if(plugin.getItem().isEnabled()){
    							pluginItems.add(plugin);
    						}
    					}
    				}
    			}
    		}
    	}catch(Exception e){    		    		
    		TuxGuitar.instance().showErrorMessage(e);
    	}catch(Error e){    		
    		TuxGuitar.instance().showErrorMessage(e);
    	}
    }
        
    public void initPLugins(){    	
    	Iterator it = plugins.iterator();
    	while(it.hasNext()){
    		try{
    			TGPlugin plugin = (TGPlugin)it.next();
    			plugin.init(TuxGuitar.instance());
        	}catch(Exception e){    		
        		TuxGuitar.instance().showErrorMessage(e);
        	}catch(Error e){    		
        		TuxGuitar.instance().showErrorMessage(e);
        	}  
    	}   	
    }
    
    public void closePLugins(){    	
    	Iterator it = plugins.iterator();
    	while(it.hasNext()){
    		try{	
    			TGPlugin plugin = (TGPlugin)it.next();
    			plugin.close();
    		}catch(Exception e){    		
        		TuxGuitar.instance().showErrorMessage(e);
        	}catch(Error e){    		
        		TuxGuitar.instance().showErrorMessage(e);
        	}
    	}    	    	
    }

}
