package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;

public class MainOption  extends Option{	
	private Button showSplash;
	private Text windowTitle;
    
    public MainOption(ConfigEditor configEditor,ToolBar toolBar,final Composite parent){
        super(configEditor,toolBar,parent,TuxGuitar.getProperty("settings.config.main"));            
    }        

    public void createOption(){		
		getToolItem().setText(TuxGuitar.getProperty("settings.config.main"));	
		getToolItem().setImage(SystemImages.OPTION_VIEW);
		getToolItem().addSelectionListener(this);
		
		showLabel(getComposite(),SWT.TOP | SWT.LEFT | SWT.WRAP,SWT.BOLD,0,TuxGuitar.getProperty("settings.config.main.window-title"));
		
		Composite windowTitleComposite = new Composite(getComposite(),SWT.NONE);
		windowTitleComposite.setLayout(new GridLayout());
		windowTitleComposite.setLayoutData(getTabbedData());
	
		this.windowTitle = new Text(windowTitleComposite,SWT.BORDER);		
		this.windowTitle.setLayoutData(new GridData(MINIMUN_WIDTH,SWT.DEFAULT));
		this.windowTitle.setTextLimit(80);
		this.windowTitle.setText(getConfig().getStringConfigValue(ConfigKeys.WINDOW_TITLE));
				
		Composite infoHeader = new Composite(windowTitleComposite,SWT.NONE);
		infoHeader.setLayout(new GridLayout(2,false));
		infoHeader.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
				
		showImageLabel(infoHeader,SWT.NONE,infoHeader.getDisplay().getSystemImage(SWT.ICON_INFORMATION));
		showLabel(infoHeader,SWT.TOP | SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.help"));		
		
		Composite infoBody = new Composite(windowTitleComposite,SWT.NONE);
		infoBody.setLayout(new GridLayout(2,false));
		infoBody.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_APP_NAME));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_APP_NAME ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_APP_VERSION));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_APP_VERSION ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_FILE_NAME));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_FILE_NAME ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_FILE_PATH));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_FILE_PATH ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_SONG_NAME));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_SONG_NAME ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_SONG_ALBUM));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_SONG_ALBUM ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_SONG_INTERPRET));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_SONG_INTERPRET ));
		
		showLabel(infoBody, SWT.NONE,SWT.BOLD,-1,WindowTitleUtil.getVar(WindowTitleUtil.VAR_SONG_AUTHOR));
		showLabel(infoBody,SWT.TOP | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.main.window-title.var.description." + WindowTitleUtil.VAR_SONG_AUTHOR ));	
		
		showLabel(getComposite(),SWT.BOTTOM | SWT.LEFT | SWT.WRAP,SWT.BOLD,0,TuxGuitar.getProperty("settings.config.main.options"));
		
		Composite options = new Composite(getComposite(),SWT.NONE);
		options.setLayout(new GridLayout(2,false));
		options.setLayoutData(getTabbedData());
	
		this.showSplash = new Button(options,SWT.CHECK);
		this.showSplash.setLayoutData(spanData(new GridData(),2));
		this.showSplash.setText(TuxGuitar.getProperty("settings.config.main.splash-enabled"));
		this.showSplash.setSelection(getConfig().getBooleanConfigValue(ConfigKeys.SHOW_SPLASH));				
    }                  
    
    private GridData spanData(GridData data,int horizontalSpan){
    	data.horizontalSpan = horizontalSpan;
    	return data;
    }

    public void updateConfig(){
    	getConfig().setProperty(ConfigKeys.WINDOW_TITLE,this.windowTitle.getText());
        getConfig().setProperty(ConfigKeys.SHOW_SPLASH,this.showSplash.getSelection());
    }    
    
    public void applyConfig(boolean force){
    	TuxGuitar.instance().showTitle();
    }
}    