package org.herac.tuxguitar.gui.printer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.util.ImageUtils;

public class PrintableImpl implements Printable{
	private PrintDocument document;
	
	public PrintableImpl(PrintDocument document){
		this.document = document;
	}	
	
	public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
		if(this.document.count() > pageIndex){
			System.out.println("Printing page: " + pageIndex);
			PrintPage page = (PrintPage)this.document.getPages().get(pageIndex);
			ImageData data = page.getData();
			
			Graphics2D g2d = (Graphics2D)graphics;			
			int x = (int)pageFormat.getImageableX();
			int y = (int)pageFormat.getImageableY();
			g2d.drawImage(ImageUtils.convertToAWT(data),null,x,y);
			
			return PAGE_EXISTS;
		}		
		return NO_SUCH_PAGE;
	}


	public PrintDocument getPrintDocument() {
		return this.document;
	}
		
}
