/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PrinterViewLayout extends ViewLayout{
	
	public static final boolean AUTO_SPACING_ENABLED = true;	
	protected static final int DEFAULT_SCORE_LINE_SPAN = 7;
	protected static final int DEFAULT_STRING_SPAN = 8;
	protected static final int MIN_SCORE_TAB_SPAN =  20;
	protected static final int DEFAULT_SCORE_SPAN = ((DEFAULT_SCORE_LINE_SPAN * 5) + MIN_SCORE_TAB_SPAN);	
	protected static final int DEFAULT_TRACK_SPAN = 8;
	protected static final int DEFAULT_FIRST_TRACK_SPAN = DEFAULT_TRACK_SPAN;
		
	private PrintDocument document;
	private PrintDocumentData documentData;
    private Image image;
    private int divisionCount;        
    
    public PrinterViewLayout(Tablature tablature,SongManager songManager,PrintDocumentData data){
        super(tablature,songManager,false,data.isScoreEnabled(),data.isTablatureEnabled());
        this.documentData = data;
    }
    
    public int getMode(){
    	return 0;
    }
    
    public PrintDocument makeDocument(Rectangle size){    	
    	//-------init document-------------------------------------------------------
    	this.document = new PrintDocument();
    	this.document.setPageSize(size);
    	//-------draw the image------------------------------------------------------
    	this.image = new Image(getTablature().getDisplay(),this.document.getPageSize());
    	GC gc = new GC(this.image);
    	paintHeader(gc);
    	paintSong(gc,0,80);
    	gc.dispose();
    	this.image.dispose();
    	
    	return this.document;
    }
    
    private void makePage(GC gc){
    	String pageNumber = Integer.toString(this.document.count() + 1);
    	
    	setDefaultStyle(gc);
    	gc.setForeground(getTablature().getDisplay().getSystemColor(SWT.COLOR_BLACK));
    	gc.drawString(pageNumber,getRight(gc,pageNumber),this.document.getPageSize().height - (gc.stringExtent(pageNumber).y + 5));
    	
    	this.document.makePage(this.image.getImageData());
    	gc.fillRectangle(this.document.getPageSize());
    }
    
    public void paintHeader(GC gc){
    	String songName = getSongManager().getSong().getName();
    	String songAuthor = getSongManager().getSong().getAuthor();
    	String trackName = "(" + getSongManager().getTrack(documentData.getTrackNumber()).getName() + ")";
    	
    	if(songName == null || songName.length() == 0){
    		songName = TuxGuitar.getProperty("print-header.default-song-name");
    	}
    	if(songAuthor == null || songAuthor.length() == 0){
    		songAuthor = TuxGuitar.getProperty("print-header.default-song-author");
    	}
    	Font songNameFont = new Font(getTablature().getDisplay(),"Sans",16, SWT.BOLD | SWT.CENTER);
    	Font trackNameFont = new Font(getTablature().getDisplay(),"Sans",8, SWT.BOLD | SWT.CENTER);
    	Font songAuthorFont = new Font(getTablature().getDisplay(),"Sans",8, SWT.BOLD | SWT.CENTER);
    		
    	gc.setFont(songNameFont);  
    	gc.drawString(songName,getCenter(gc,songName),0);
    	gc.setFont(trackNameFont);
    	gc.drawString(trackName,getCenter(gc,trackName),30);
    	gc.setFont(songAuthorFont);
    	gc.drawString(songAuthor,getRight(gc,songAuthor),50);
    	
    	songNameFont.dispose();
    	trackNameFont.dispose();
    	songAuthorFont.dispose();
    	
    	setDefaultStyle(gc);
    }
    
    private int getCenter(GC gc,String text){
    	int textWidth = gc.stringExtent(text).x;
    	return ((getMaxWidth() - textWidth) / 2);
    }

    private int getRight(GC gc,String text){
    	int textWidth = gc.stringExtent(text).x;
    	return ((getMaxWidth() - textWidth));
    }
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){
    	
    }
    
    public void paintSong(GC gc,int fromX,int fromY){ 
        List tracksCoords = new ArrayList();        
        tracksCoords.add(getTablature().getCaret().getSongCoords().getTrack(documentData.getTrackNumber()));
        paintTracks(tracksCoords,gc,null,fromX,fromY);        
    }
    
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {    	
    	int posY = fromY + getDefaultFirstTrackSpan();
    	int height = getDefaultFirstTrackSpan();
    	int lineHeight = 0;    	
    	
    	SongTrackCoords trackCoords = (SongTrackCoords)tracksCoords.get(0);		
		trackCoords.getLyricPainter().start(getSkippedBeats(trackCoords.getMeasuresCoords()));
		TrackSpacing ts = new TrackSpacing(this) ;
		TempLine line = getTempLines(fromX,trackCoords.getMeasuresCoords(),( documentData.getFromMeasure() - 1 ),ts);
		while(!line.measures.isEmpty()){
    		            
            ts.setSize(TrackSpacing.POSITION_SCORE_MIDDLE_LINES, ((isScoreEnabled())?( (DEFAULT_SCORE_LINE_SPAN * 5) ):0));
			if(AUTO_SPACING_ENABLED && isScoreEnabled()){    			
            	ts.setSize(TrackSpacing.POSITION_SCORE_UP_LINES, Math.abs(line.minY));            	            
            	if(isScoreEnabled() && line.maxY + MIN_SCORE_TAB_SPAN > DEFAULT_SCORE_SPAN){
            		ts.setSize(TrackSpacing.POSITION_SCORE_DOWN_LINES, (line.maxY - (getScoreLineSpan() * 4)) );
            	}	
			}    	
            ts.setSize(TrackSpacing.POSITION_TABLATURE_TOP_SEPARATOR,(isScoreEnabled()?getMinScoreTabSpan():getStringSpan()));
            ts.setSize(TrackSpacing.POSITION_TABLATURE, ( isTablatureEnabled()?(isScoreEnabled()?trackCoords.getTabHeight() + getStringSpan() +1:trackCoords.getTabHeight() + ((getStringSpan() / 2) * 5) +1 ) :0) );
            ts.setSize(TrackSpacing.POSITION_LYRIC,10);            
            checkTopSpan(ts);
            
			lineHeight = ts.getSize();    			
    		//Verifico si entra en la pagina actual
    		if((posY + lineHeight + DEFAULT_TRACK_SPAN) > getMaxHeight()){
               	makePage(gc);
               	posY = getDefaultFirstTrackSpan();
            }    			
    		//pinto la linea
    		paintLine(trackCoords,line,gc,fromX,posY,ts,clientArea);
                
            posY += lineHeight + DEFAULT_TRACK_SPAN;    
    		height += lineHeight + DEFAULT_TRACK_SPAN;           		       
    		
    		ts = new TrackSpacing(this) ;
    		line = getTempLines(fromX,trackCoords.getMeasuresCoords(),( line.lastIndex + 1 ),ts);
    	}    	

    	//Creo la ultima pagina
       	makePage(gc);
    	
    	setHeight(height);
    }
    
    
    
    public void paintLine(SongTrackCoords trackCoords,TempLine line,GC gc,int fromX, int fromY,TrackSpacing ts,Rectangle clientArea) {  
    	int posX = fromX;//(fromX + DEFAULT_HORIZONTAL_SPAN);
        int posY = fromY;
        int width = 0;
        int height = 0;        

        int measureSpan = 0;
        if(line.fullLine){
        	int diff = ( getMaxWidth() - line.tempWith);
        	if(diff != 0 && line.measures.size() > 0){
        		measureSpan = diff / line.measures.size();                    
        	}
        }
            
        for(int i = 0;i < line.measures.size();i ++){
          	int index = ((Integer)line.measures.get(i)).intValue();
            MeasureCoords currMeasureCoords = (MeasureCoords)trackCoords.getMeasuresCoords().get(index);
                    
            //asigno la posicion dentro del compas
            currMeasureCoords.setPosX(posX);
            currMeasureCoords.setPosY(posY);              
            currMeasureCoords.setTs(ts);
            
            trackCoords.getLyricPainter().setCurrentMeasure(currMeasureCoords);
            
            currMeasureCoords.setFirstOfLine(i == 0);

            paintMeasure(currMeasureCoords,gc,posX, posY,measureSpan,clientArea);
            trackCoords.getLyricPainter().paintCurrentNoteBeats(gc,this,currMeasureCoords,posX, posY);
                    
            posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
            
            if(posX > width){
                width = posX;
                
            }                                                        
        }                

        setWidth((width > getWidth())?width:getWidth());
    }                     
    
    public TempLine getTempLines(int posX,List measuresCoords,int fromIndex,TrackSpacing ts) {          
    	TempLine line = new TempLine();
    	this.divisionCount = 1;        
        for (int measureIdx = fromIndex; measureIdx < measuresCoords.size(); measureIdx++) {         	
            MeasureCoords measure= (MeasureCoords) measuresCoords.get(measureIdx);                
            if(measure.getMeasure().getNumber() >= documentData.getFromMeasure() && measure.getMeasure().getNumber() <= documentData.getToMeasure() ){
         
            	//verifico si tengo que bajar de linea
            	if((line.tempWith + measure.getWidth()) >=  getMaxWidth() && !line.measures.isEmpty()){
            		line.fullLine = true;
            		return line;
            	}
            	line.tempWith +=  measure.getWidth();
            	line.maxY = (measure.getMaxY() > line.maxY)?measure.getMaxY():line.maxY;
            	line.minY = (measure.getMinY() < line.minY)?measure.getMinY():line.minY;
        	
            	line.addMeasure(measureIdx);
            	measure.registerEffects(ts);
            }
        }        
       
        return line;
    }    
    
    public int getSkippedBeats(List measuresCoords) {
    	int beats = 0;
    	
        for (int i = 0; i < (documentData.getFromMeasure() - 1); i++) {         	
            MeasureCoords measure = (MeasureCoords) measuresCoords.get(i);    
            beats += measure.getBeatPositions().size();
        }               
        return beats;
    }    
    
    
    /**
     * Calcula el espacio minimo entre negras, dependiendo de la duracion de la nota 
     */
    public int getSpanForQuarter(Duration duration){        
        double span = ((double)Duration.QUARTER_TIME / (double)duration.getTime()) * getMinSpan(duration);
        return  (int)span;
    }       
    
    /**
     * Calcula el Espacio minimo que quedara entre nota y nota
     */
    private int getMinSpan(Duration duration){
        int minSpan = 0;
        switch(duration.getValue()){
        	case Duration.WHOLE:
        	    minSpan = 18;
        	    break;
        	case Duration.HALF:
        	    minSpan = 16;
        	    break;
        	case Duration.QUARTER:
        	    minSpan = 14;
        	    break;
        	case Duration.EIGHTH:
        	    minSpan = 12;
        	    break;       
        	default:
        	    minSpan = 12;
        	    break;
        }        
        return minSpan;        
    } 
        
    public boolean followMeasure(MeasureCoords measure,boolean redraw){
    	return false;
    }       
    
    public boolean isCaretVisible(){
    	return false;
    }

    public boolean isPlayModeEnabled(){
    	return false;
    }

    public void setDefaultStyle(GC gc){
    	gc.setFont(getTablature().getPrinterDefaultFont());
    }    
    
    public void setNoteStyle(GC gc){
    	gc.setFont(getTablature().getPrinterNoteFont());    	
    }
    
    public void setTimeSignatureStyle(GC gc){
    	gc.setFont(getTablature().getPrinterTimeSignatureFont());    	
    }
    
    public int getMaxWidth(){
        return (this.document.getPageSize().width - 10);
    }
    
    public int getMaxHeight(){
        return this.document.getPageSize().height;
    }    

    public boolean isFirstMeasure(Measure measure){
    	return (measure.getNumber() == documentData.getFromMeasure());
    }

    public boolean isLastMeasure(Measure measure){
    	return (measure.getNumber() == documentData.getToMeasure());
    }

    public int getStringSpan(){
    	return DEFAULT_STRING_SPAN;
    }
        
    public int getScoreLineSpan(){
    	return DEFAULT_SCORE_LINE_SPAN;
    }       
    
    public int getDefaultTrackSpan(){
    	return DEFAULT_TRACK_SPAN;
    }

    public int getMinScoreTabSpan(){
    	return MIN_SCORE_TAB_SPAN;
    }    
    
    public int getDefaultFirstTrackSpan(){
    	return DEFAULT_FIRST_TRACK_SPAN;
    }
    
    public int getDefaultEffectSpan(){
    	return super.getDefaultEffectSpan();
    }     
    
    private class TempLine{    	
    	private int tempWith;    	
    	private int lastIndex;
    	private int startBeat;
    	private boolean fullLine;
    	private List measures = new ArrayList();
    	
    	private int maxY = 0;
    	private int minY = 50;
    	
    	private void addMeasure(int index){
    		this.measures.add(new Integer(index));
    		this.lastIndex = index;
    	}
    }
}
