package org.herac.tuxguitar.gui.editors.lyric;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.track.GoNextTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoPreviousTrackAction;
import org.herac.tuxguitar.song.models.SongTrack;

public class LyricEditor {
	private static int EDITOR_WIDTH = 400;
	private static int EDITOR_HEIGHT = 200;
	
	private SongTrack track;
	private Shell dialog;
	private LyricModifyListener listener;
	private Label label;
	private Spinner from;
	private Text text;
	
	
	public LyricEditor(){		
		this.listener = new LyricModifyListener(this);
	}
	
	public void show() {		
		Shell shell = TuxGuitar.instance().getShell();
		Rectangle sBounds = shell.getBounds();
		Rectangle dBounds = shell.getDisplay().getBounds();

		this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.RESIZE);
		this.dialog.setLayout(new GridLayout());
		this.dialog.setText(TuxGuitar.getProperty("lyric.editor"));
		
		this.updateSongTrack();
		this.loadComposites();
		
		

        int x = shell.getBounds().x + (shell.getBounds().width - EDITOR_WIDTH) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - EDITOR_HEIGHT) / 2;
        
        this.dialog.setSize(EDITOR_WIDTH,EDITOR_HEIGHT);
        this.dialog.setLocation(x, y);
		this.dialog.open();		
		
		while (!dialog.isDisposed()) {
			if (!dialog.getDisplay().readAndDispatch()) {
				dialog.getDisplay().sleep();
			}
		}	
				
		this.track = null;
		this.label = null;
		this.text = null;		
		this.dialog = null;				
	}

	private void loadComposites(){
		
		Composite composite = new Composite(this.dialog,SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		loadToolBar(composite);
		loadLyricText(composite);
	}


	private void loadToolBar(Composite parent){		
		final Composite composite = new Composite(parent,SWT.NONE);
		composite.setLayout(new GridLayout(5,false));
		composite.setLayoutData(new GridData(SWT.FILL,SWT.NONE,true,false));
		
		Button previous = new Button(composite, SWT.ARROW | SWT.LEFT);
		Button next = new Button(composite, SWT.ARROW | SWT.RIGHT);
		
		this.label = new Label(composite,SWT.NONE);
		this.label.setText(this.track.getName());
		this.label.setLayoutData(new GridData(SWT.FILL,SWT.CENTER,true,true));
		
		
		Label fromLabel = new Label(composite,SWT.NONE);
		fromLabel.setText(TuxGuitar.getProperty("edit.from"));
		fromLabel.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,false,true));

		
		//GridData fromData = new GridData(SWT.END,SWT.CENTER,false,true);
		//fromData.widthHint = 24;
		
		this.from = new Spinner(composite,SWT.BORDER);
		this.from.setLayoutData(getSpinnerData());
		
		this.from.setMinimum(1);
		this.from.setMaximum(this.track.getMeasures().size());
		this.from.setSelection(this.track.getLyrics().getFrom());
		this.from.setEnabled(this.track.getMeasures().size() > 1);
		this.from.addModifyListener(this.listener);
		
		
		previous.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getAction(GoPreviousTrackAction.NAME).process(e);
				composite.layout();
			}		
		});		
		next.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getAction(GoNextTrackAction.NAME).process(e);
			}		
		});		
		
	}

    private GridData getSpinnerData(){
    	GridData data = new GridData();
    	//data.horizontalAlignment = SWT.RIGHT;
    	//data.grabExcessHorizontalSpace = false;
    	
    	//GridData data = new GridData(SWT.RIGHT,SWT.DEFAULT,false,true);
    	//data.minimumWidth = 40;
    	return data;
    }

	private void loadLyricText(Composite parent){
		
		Composite composite = new Composite(parent,SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		this.text = new Text(composite,SWT.BORDER | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		this.text.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		this.text.setFocus();
		this.text.setText(this.track.getLyrics().getLyrics());		
		this.text.addModifyListener(this.listener);
	}
	
	public void updateSongTrack(){
		if(this.dialog != null && !this.dialog.isDisposed()){
			this.track = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSongTrackCoords().getTrack();			
			if(this.label != null && !this.label.isDisposed()){
				this.label.setText(this.track.getName());
			}
			if(this.from != null && !this.from.isDisposed()){				
				this.from.setMaximum(this.track.getMeasures().size());
				this.from.setSelection(this.track.getLyrics().getFrom());
				this.from.setEnabled(this.track.getMeasures().size() > 1);
			}			
			if(this.text != null && !this.text.isDisposed()){
				this.text.setText(this.track.getLyrics().getLyrics());
			}
		}
	}	
	
	public SongTrack getTrack(){
		return this.track;
	}
	
}
