/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SaveFileAction extends Action{
    public static final String NAME = "action.file.save";
    
    public SaveFileAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {    	
        final String fileName = TuxGuitar.instance().getFileHistory().getFilePath() + File.separator + TuxGuitar.instance().getFileHistory().getFileName();
        
        if (TuxGuitar.instance().getFileHistory().isNewFile() || !isSuportedFormat(fileName)) {
        	TuxGuitar.instance().getAction(SaveAsFileAction.NAME).process(e);
        }else{
            getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
            new SyncThread(new Runnable() {
            	public void run() {
            		if(!TuxGuitar.isDisposed()){
            			getEditor().getSongManager().save(fileName);
                        getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
                    }
            	}
            }).start();                                             
        }   
        
        return true;
    }
    
	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(".tg") || fileName.endsWith(".gp3") || fileName.endsWith(".gp4"));
	}

}
