/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTripletFeel;
import org.herac.tuxguitar.song.models.MeasureHeader;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTripletFeelAction extends Action{
    public static final String NAME = "action.composition.change-triplet-feel";
    
    public ChangeTripletFeelAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell()); 
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("composition.tripletfeel"));
            
            //-------------TIME SIGNATURE-----------------------------------------------
            Composite tripletFeel = new Composite(dialog, SWT.NONE);
            tripletFeel.setLayout(new GridLayout());
            tripletFeel.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            
            //none
            final Button tripletFeelNone = new Button(tripletFeel, SWT.RADIO);
            tripletFeelNone.setText(TuxGuitar.getProperty("composition.tripletfeel.none"));
            tripletFeelNone.setSelection(measure.getMeasure().getTripletFeel() == MeasureHeader.TRIPLET_FEEL_NONE);
            
            final Button tripletFeelEighth = new Button(tripletFeel, SWT.RADIO);
            tripletFeelEighth.setText(TuxGuitar.getProperty("composition.tripletfeel.eighth"));
            tripletFeelEighth.setSelection(measure.getMeasure().getTripletFeel() == MeasureHeader.TRIPLET_FEEL_EIGHTH);
            
            final Button tripletFeelSixteenth = new Button(tripletFeel, SWT.RADIO);
            tripletFeelSixteenth.setText(TuxGuitar.getProperty("composition.tripletfeel.sixteenth"));
            tripletFeelSixteenth.setSelection(measure.getMeasure().getTripletFeel() == MeasureHeader.TRIPLET_FEEL_SIXTEENTH);
            
            //--------------------To End Checkbox-------------------------------
            Composite check = new Composite(dialog, SWT.NONE);
            check.setLayout(new GridLayout());
            check.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    
           
            final Button toEnd = new Button(check, SWT.CHECK);
            toEnd.setText(TuxGuitar.getProperty("composition.tripletfeel.to-the-end"));            
            toEnd.setSelection(true);
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;            
            
            
            final Button buttonOk = new Button(buttons, SWT.PUSH);
            buttonOk.setText(TuxGuitar.getProperty("ok"));
            buttonOk.setLayoutData(data);
            buttonOk.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean toEndValue = toEnd.getSelection();
                    int tripletFeel = MeasureHeader.TRIPLET_FEEL_NONE;
                    if(tripletFeelNone.getSelection()){
                    	tripletFeel = MeasureHeader.TRIPLET_FEEL_NONE;
                    }else if(tripletFeelEighth.getSelection()){
                    	tripletFeel = MeasureHeader.TRIPLET_FEEL_EIGHTH;
                    }else if(tripletFeelSixteenth.getSelection()){
                    	tripletFeel = MeasureHeader.TRIPLET_FEEL_SIXTEENTH;
                    }
                    setTripletFeel(tripletFeel,toEndValue);
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setLayoutData(data);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.setMinimumSize(300,0);
            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
    
    private void setTripletFeel(int tripletFeel,boolean toEnd){
        //comienza el undoable
    	UndoableChangeTripletFeel undoable = UndoableChangeTripletFeel.startUndo(); 
    	
        Caret caret = getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        
        getSongManager().changeTripletFeel(measure.getMeasure().getStart(),tripletFeel,toEnd);
        
        //actualizo la tablatura
        updateTablature();
        redraw();                
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(tripletFeel,toEnd));
    }    

}
