/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTempo;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.Tempo;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTempoAction extends Action{
    public static final String NAME = "action.composition.change-tempo";
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;
    
    private static final int[] DEFAULT_PERCENTS = new int[]{25,50,75,100,125,150,175,200};
    
    public ChangeTempoAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("composition.tempo"));

            //-----------------TEMPO------------------------
            Composite composite = new Composite(dialog, SWT.NONE);
            composite.setLayout(new GridLayout(2,false));
            composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true)); 
            
            Tempo currentTempo = measure.getMeasure().getTempo();
            Label tempoLabel = new Label(composite, SWT.NULL);
            tempoLabel.setText(TuxGuitar.getProperty("composition.tempo"));
                        
            final Spinner tempo = new Spinner(composite, SWT.BORDER);
            tempo.setLayoutData(getSpinnerData());            
            tempo.setMinimum(MIN_TEMPO);
            tempo.setMaximum(MAX_TEMPO);
            tempo.setSelection(currentTempo.getValue());                                    
            
            Label percentLabel = new Label(composite, SWT.NULL);
            percentLabel.setText(TuxGuitar.getProperty("composition.tempo-percent"));
            
            final Combo percent = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
            percent.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            for(int i = 0; i < DEFAULT_PERCENTS.length; i ++){
            	percent.add(Integer.toString(DEFAULT_PERCENTS[i]) + "%",i);
            	if(currentTempo.getPercent() == DEFAULT_PERCENTS[i]){
            		percent.select(i);
            	}
            }            
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;     
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean valid = false;
                   
                    int tempoValue = tempo.getSelection();
                                      
                    if(tempoValue >= MIN_TEMPO && MAX_TEMPO <= 320){
                    	Tempo tempo = new Tempo(tempoValue,DEFAULT_PERCENTS[ (percent.getSelectionIndex() >= 0)?percent.getSelectionIndex():3 ]);                                       
                        setTempo(tempo);
                        valid = true;
                    }
               
                    if(!valid){
                        showErrorMessage(TuxGuitar.getProperty("composition.tempo.invalid"));
                    }
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
    private GridData getSpinnerData(){
    	GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);
    	data.minimumWidth = 150;
    	return data;
    }
    
    private void setTempo(Tempo tempo){
        //comienza el undoable
    	UndoableChangeTempo undoable = UndoableChangeTempo.startUndo(); 
    	
        Caret caret = getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        
        getSongManager().changeTempo(measure.getMeasure().getStart(),tempo,true);
        
        //actualizo la tablatura
        updateTablature();
        redraw();                
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(tempo));
    }    

    
    private void showErrorMessage(String message){            
        String name = "Error Message";
        new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());        
    }    
}
