-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Globals; use Globals;


package Configuration is

   Switch_Parse_Error : exception;
   function Set_Two_Way (S : String) return Boolean;

   Two_Way : constant array (Boolean) of UBS
     := (True => ToUBS("on"),
         False => ToUBS("off"));

   Config_Parse_Error : exception;
   procedure Read_Config_File;

   procedure Dump (Overwrite_Config : in Boolean := False);

   procedure Edit_Configuration;

   procedure Default_Configuration (C : in out Config_Record);

   -- Deep copy the configuration.  Right is the original; Left is the
   -- newly instantiated configuration.
   procedure Copy_Configuration(Left  : in out Config_Record;
                                Right : in     Config_Record);

end Configuration;

