package tijmp.ui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tijmp.actions.FrameCloser;

/** A class that can show a simple window with a single component in it.
 */
public class ShowSimpleFrame {
    public void showFrame (String title, JComponent p, Action ... actions) {
	JFrame f = new JFrame (title);
	f.add (p, BorderLayout.CENTER);
	f.setDefaultCloseOperation (JFrame.DISPOSE_ON_CLOSE);
	JPanel buttons = new JPanel ();
	buttons.setLayout (new FlowLayout (FlowLayout.RIGHT));
	for (Action a : actions)
	    buttons.add (new JButton (a));
	final JButton close = new JButton (new FrameCloser (f));
	buttons.add (close);
	f.getRootPane ().setDefaultButton (close);

	/** Map escape to close the frame */
	close.getInputMap (JComponent.WHEN_IN_FOCUSED_WINDOW).
	    put (KeyStroke.getKeyStroke (KeyEvent.VK_ESCAPE, 0), 
		 "abort");
	close.getActionMap ().put ("abort", new AbstractAction () {
		public void actionPerformed (ActionEvent e) {
		    close.doClick ();
		}
	    });	

	f.add (buttons, BorderLayout.SOUTH);
	f.pack ();
	f.setVisible (true);
    }    
}
