/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.api.*;
import org.jvnet.substance.api.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.colorscheme.*;
import org.jvnet.substance.painter.border.ClassicInnerBorderPainter;
import org.jvnet.substance.painter.decoration.BrushedMetalDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.gradient.ClassicGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

/**
 * <code>Office Silver 2007</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 */
public class OfficeSilver2007Skin extends SubstanceSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static final String NAME = "Office Silver 2007";

	/**
	 * Creates a new <code>Office Silver 2007</code> skin.
	 */
	public OfficeSilver2007Skin() {
		SubstanceColorScheme activeScheme = new OrangeColorScheme().saturate(
				-0.1).named("Office Silver 2007 Active");
		SubstanceColorScheme defaultScheme = new BlendBiColorScheme(
				new MetallicColorScheme(), new LightGrayColorScheme(), 0.7)
				.tint(0.1).named("Office Silver 2007 Default");
		SubstanceColorScheme disabledScheme = new LightGrayColorScheme().tint(
				0.2).named("Office Silver 2007 Disabled");

		SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(
				activeScheme, defaultScheme, disabledScheme);

		// register state-specific color schemes on rollovers and selections
		defaultSchemeBundle.registerColorScheme(new BlendBiColorScheme(
				new OrangeColorScheme(), new SunGlareColorScheme()
						.saturate(-0.1), 0.4)
				.named("Office Silver 2007 Rollover Unselected"),
				ComponentState.ROLLOVER_UNSELECTED);
		defaultSchemeBundle.registerColorScheme(new BlendBiColorScheme(
				new OrangeColorScheme(), new SunsetColorScheme(), 0.3)
				.named("Office Silver 2007 Rollover Selected"),
				ComponentState.ROLLOVER_SELECTED);
		defaultSchemeBundle.registerColorScheme(new BlendBiColorScheme(
				new RaspberryColorScheme(), new SunsetColorScheme(), 0.6)
				.saturate(0.2).named("Office Silver 2007 Pressed Selected"),
				ComponentState.PRESSED_SELECTED);
		defaultSchemeBundle.registerColorScheme(new BlendBiColorScheme(
				new RaspberryColorScheme(), new SunsetColorScheme(), 0.2)
				.named("Office Silver 2007 Pressed Unselected"),
				ComponentState.PRESSED_UNSELECTED);

		// register state-specific highlight color schemes on rollover and
		// selections
		defaultSchemeBundle.registerHighlightColorScheme(
				new BlendBiColorScheme(new OrangeColorScheme(),
						new SunGlareColorScheme(), 0.3).saturate(0.3).named(
						"Office Silver 2007 Rollover Unselected Highlight"),
				0.5f, ComponentState.ROLLOVER_UNSELECTED);
		defaultSchemeBundle.registerHighlightColorScheme(
				new BlendBiColorScheme(new OrangeColorScheme(),
						new SunsetColorScheme(), 0.8)
						.named("Office Silver 2007 Selected Highlight"), 0.5f,
				ComponentState.SELECTED);
		defaultSchemeBundle
				.registerHighlightColorScheme(
						new BlendBiColorScheme(new OrangeColorScheme(),
								new SunsetColorScheme(), 0.2)
								.named("Office Silver 2007 Rollover Selected Highlight"),
						0.7f, ComponentState.ROLLOVER_SELECTED);
		defaultSchemeBundle.registerHighlightColorScheme(
				new BlendBiColorScheme(new OrangeColorScheme(),
						new SunsetColorScheme(), 0.8)
						.named("Office Silver 2007 Rollover Armed Highlight"),
				0.7f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);

		registerDecorationAreaSchemeBundle(defaultSchemeBundle,
				DecorationAreaType.NONE);

		this.registerAsDecorationArea(defaultScheme,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.FOOTER,
				DecorationAreaType.GENERAL);

		this.setSelectedTabFadeStart(0.1);
		this.setSelectedTabFadeEnd(0.3);
		this.setPaintingDropShadows(DecorationAreaType.TOOLBAR);

		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceStripeWatermark();
		this.gradientPainter = new ClassicGradientPainter();
		this.borderPainter = new ClassicInnerBorderPainter(0.8f,
				ColorShiftKind.TINT);

		BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
		decorationPainter.setPaintingSeparators(true);
		decorationPainter.setTextureAlpha(0.45f);
		this.decorationPainter = decorationPainter;

		this.highlightPainter = new ClassicHighlightPainter();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
