package test.contrib.martin;

import java.awt.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class SliderTest extends JFrame {

	protected static class RulerPanel extends JPanel {
		@Override
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);

			Graphics2D graphics = (Graphics2D) g.create();
			int width = this.getWidth();
			int height = this.getHeight();

			graphics.setColor(new Color(200, 200, 200));
			for (int x = 3; x < width; x += 4) {
				graphics.drawLine(x, 0, x, height);
			}
			for (int y = 3; y < height; y += 4) {
				graphics.drawLine(0, y, width, y);
			}
		}
	}

	public SliderTest() {
		JDialog.setDefaultLookAndFeelDecorated(true);
		JFrame.setDefaultLookAndFeelDecorated(true);
		this.setLayout(new BorderLayout());
		JPanel content = new RulerPanel();
		content.setLayout(null);
		this.add(content, BorderLayout.CENTER);

		JSlider slider = new JSlider(0, 100, 50);
		slider.setBounds(10, 10, 20, 100);
		slider.setOrientation(JSlider.VERTICAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		slider = new JSlider(0, 100, 50);
		slider.setBounds(50, 10, 30, 100);
		slider.setOrientation(JSlider.VERTICAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		slider = new JSlider(0, 100, 50);
		slider.setBounds(100, 10, 40, 100);
		slider.setOrientation(JSlider.VERTICAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		slider = new JSlider(0, 100, 50);
		slider.setBounds(10, 150, 100, 20);
		slider.setOrientation(JSlider.HORIZONTAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		slider = new JSlider(0, 100, 50);
		slider.setBounds(120, 150, 100, 30);
		slider.setOrientation(JSlider.HORIZONTAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		slider = new JSlider(0, 100, 50);
		slider.setBounds(240, 150, 100, 40);
		slider.setOrientation(JSlider.HORIZONTAL);
		slider.setOpaque(false);
		slider.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		content.add(slider);

		JCheckBox checkbox = new JCheckBox("checkbox - opaque");
		checkbox.setBounds(10, 220, 150, 20);
		checkbox.setOpaque(true);
		checkbox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		checkbox.setBackground(Color.YELLOW);
		content.add(checkbox);

		checkbox = new JCheckBox("checkbox - transparent");
		checkbox.setBounds(180, 220, 150, 20);
		checkbox.setOpaque(false);
		checkbox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		checkbox.setBackground(Color.YELLOW);
		content.add(checkbox);

		JRadioButton radiobutton = new JRadioButton("radiobutton - opaque");
		radiobutton.setBounds(10, 280, 150, 20);
		radiobutton.setOpaque(true);
		radiobutton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		radiobutton.setBackground(Color.YELLOW);
		content.add(radiobutton);

		radiobutton = new JRadioButton("radiobutton - transparent");
		radiobutton.setBounds(180, 280, 150, 20);
		radiobutton.setOpaque(false);
		radiobutton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		radiobutton.setBackground(Color.YELLOW);
		content.add(radiobutton);

		checkbox = new JCheckBox("checkbox - default");
		checkbox.setBounds(10, 320, 150, 20);
		checkbox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		checkbox.setBackground(Color.YELLOW);
		content.add(checkbox);

		radiobutton = new JRadioButton("radiobutton - default");
		radiobutton.setBounds(180, 320, 150, 20);
		radiobutton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		radiobutton.setBackground(Color.YELLOW);
		content.add(radiobutton);

		this.setSize(400, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) {
		JFrame.setDefaultLookAndFeelDecorated(true);
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			// Do nothing
		}
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new SliderTest().setVisible(true);
			}
		});
	}
}
