package test.contrib.greg;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DateTimeJPanel extends JPanel {

   private static final long serialVersionUID = 1L;
   private JLabel _currentDate;
   private Timer timer;

   /**
    * This is the default constructor
    */
   public DateTimeJPanel() {
      super();
      initialize();
   }

   /**
    * This method initializes this
    * 
    * @return void
    */
   private void initialize() {
      _currentDate = new JLabel();
      add(_currentDate);

      timer = new Timer();
      timer.scheduleAtFixedRate(new TimerTask() {
         public void run() {
            SwingUtilities.invokeLater(new Runnable() {
               public void run() {
                  _currentDate.setText(getTime());
               }
            });
         }
      }, 0, 1000);

   }

   private String getTime() {
      String hh_string = new String("");
      String mm_string = new String("");
      String ss_string = new String("");
      Calendar now = Calendar.getInstance();
      int hh = now.get(Calendar.HOUR_OF_DAY);
      int mm = now.get(Calendar.MINUTE);
      int ss = now.get(Calendar.SECOND);
      if (hh < 10)
         hh_string = "0" + hh;
      else
         hh_string = "" + hh;
      if (mm < 10)
         mm_string = "0" + mm;
      else
         mm_string = "" + mm;
      if (ss < 10)
         ss_string = "0" + ss;
      else
         ss_string = "" + ss;
      return (hh_string + ":" + mm_string + ":" + ss_string);
   }

}
