package test.contrib.bug131;

import java.awt.Component;
import java.awt.event.ActionListener;

import javax.swing.ComboBoxEditor;

public class SubstanceEditor implements ComboBoxEditor {

    private DualTextField field;
    
    public SubstanceEditor() {
        init();
    }
    
    private void init() {
        field = new DualTextField();
        field.getRightField().setEditable(false);
        field.getLeftField().setEditable(false);
        field.setSeparator(":"); //$NON-NLS-1$
    }
    
    public Component getEditorComponent() {
        return field;
    }

    public void setItem(Object anObject) {
        if (anObject == null) {
            field.setRightFieldText(""); //$NON-NLS-1$
            field.setLeftFieldText(""); //$NON-NLS-1$
            return;
        }
        String objectString = anObject.toString();
        field.setLeftFieldText(objectString);
        field.setRightFieldText(""); //$NON-NLS-1$
        field.getRightField().setEditable(false);
        field.setRightFieldActive(false);
        field.revalidate();
    }

    public Object getItem() {
        return field.getLeftFieldText();
    }

    public void selectAll() {
        field.getLeftField().selectAll();
    }

    public void addActionListener(ActionListener l) {
        // TODO Auto-generated method stub

    }

    public void removeActionListener(ActionListener l) {
        // TODO Auto-generated method stub

    }

}
