package test.contrib;

import static java.util.Calendar.DATE;
import static java.util.Calendar.DAY_OF_MONTH;
import static java.util.Calendar.DAY_OF_WEEK;
import static java.util.Calendar.MONTH;
import static java.util.Calendar.YEAR;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.*;

import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * 
 * @author Pszczoa
 */
public class CalendarAddon extends JFrame implements MouseListener {

	public static final long serialVersionUID = 1L;

	private static final String[] DAYS_NAME_TABLE = { "Nd", "Pn", "Wt", "r",
			"Cz", "Pt", "So" };

	private JPanel calendarPanel;

	private JScrollPane calendarScrollPane;

	private JTable calendarTable;

	private JLabel monthLabel;

	private JPanel monthNavigationPanel;

	private JPanel navigationPanel;

	private JPanel todayPanel;

	private JLabel todayLabel;

	private JLabel dayLabel;

	private JButton nextMonthButton;

	private JButton previousMonthButton;

	private JSpinner yearSpinner;

	private CalendarAddonController controller;

	public CalendarAddon() {
		controller = new CalendarAddonController();

		initComponents();
		setSize(new Dimension(200, 181));
	}

	private void initComponents() {
		setTitle("Kalendarz");

		setResizable(false);

		calendarPanel = new JPanel();
		calendarScrollPane = new JScrollPane();
		calendarTable = new JTable(6, 7) {
			public boolean isCellEditable(int rowIndex, int vColIndex) {
				return false;
			}
		};

		navigationPanel = new JPanel();
		todayPanel = new JPanel();
		todayLabel = new JLabel();
		dayLabel = new JLabel();
		yearSpinner = new JSpinner();
		monthNavigationPanel = new JPanel();
		monthLabel = new JLabel();
		nextMonthButton = new JButton();
		previousMonthButton = new JButton();

		calendarPanel.setLayout(new BorderLayout());

		calendarTable.setDefaultRenderer(Object.class,
				new CalendarCellRenderer());
		calendarTable.setModel(new DefaultTableModel(controller
				.getCalendarTable(), DAYS_NAME_TABLE));

		calendarTable.addMouseListener(this);

		calendarTable.setCellSelectionEnabled(false);

		calendarTable.getColumnModel().setColumnSelectionAllowed(false);
		calendarTable.getTableHeader().setReorderingAllowed(false);
		for (int i = 0; i < calendarTable.getColumnModel().getColumnCount(); i++) {
			TableColumn col = calendarTable.getColumnModel().getColumn(i);
			col.setMinWidth(27);
			col.setMaxWidth(27);
			col.setPreferredWidth(27);

		}

		calendarScrollPane.setViewportView(calendarTable);

		calendarPanel.add(calendarScrollPane, BorderLayout.CENTER);

		add(calendarPanel, BorderLayout.CENTER);

		navigationPanel.setLayout(new BorderLayout());

		todayPanel.setLayout(new BorderLayout());

		todayLabel.setText("Dzi jest: ");

		dayLabel.setText("" + controller.getActualDay() + " "
				+ controller.getActualMonth() + " "
				+ controller.getActualYear());

		todayPanel.add(todayLabel, BorderLayout.WEST);
		todayPanel.add(dayLabel, BorderLayout.CENTER);

		add(todayPanel, BorderLayout.SOUTH);

		yearSpinner.setBorder(new EmptyBorder(0, 0, 0, 0));
		yearSpinner.setToolTipText("Rok");
		yearSpinner.setPreferredSize(new Dimension(60, 20));

		yearSpinner.setValue(controller.getActualYear());

		yearSpinner.addChangeListener(new SpinnerListener());

		SpinnerModel yearModel = new SpinnerNumberModel(controller
				.getActualYear(), controller.getActualYear() - 100, controller
				.getActualYear() + 100, 1);

		yearSpinner.setModel(yearModel);
		yearSpinner.setEditor(new JSpinner.NumberEditor(yearSpinner, "#"));

		//
		// HERE
		//

		JFormattedTextField yearSpinnerEditor = ((JSpinner.DefaultEditor) yearSpinner
				.getEditor()).getTextField();
		yearSpinnerEditor.setEditable(false);

		navigationPanel.add(yearSpinner, BorderLayout.EAST);

		monthNavigationPanel.setLayout(new BorderLayout());

		monthLabel.setHorizontalAlignment(SwingConstants.CENTER);
		monthLabel.setText(controller.getMonth());
		monthLabel.setHorizontalTextPosition(SwingConstants.CENTER);
		monthNavigationPanel.add(monthLabel, BorderLayout.CENTER);

		nextMonthButton.setFont(new Font("Arial", Font.BOLD, 9));
		nextMonthButton.setText(">");
		nextMonthButton.setToolTipText("Nast\u0119pny miesi\u0105c");
		nextMonthButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
		nextMonthButton.setPreferredSize(new Dimension(25, 23));

		nextMonthButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				controller.nextMonth();
				displayCalendarData();
			}
		});

		monthNavigationPanel.add(nextMonthButton, BorderLayout.EAST);

		previousMonthButton.setFont(new Font("Arial", Font.BOLD, 9));
		previousMonthButton.setText("<");
		previousMonthButton.setToolTipText("Poprzedni miesi\u0105c");
		previousMonthButton.setMargin(new Insets(0, 0, 0, 0));
		previousMonthButton.setPreferredSize(new Dimension(25, 23));

		previousMonthButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				controller.previousMonth();
				displayCalendarData();
			}
		});

		monthNavigationPanel.add(previousMonthButton, BorderLayout.WEST);

		navigationPanel.add(monthNavigationPanel, BorderLayout.CENTER);

		add(navigationPanel, BorderLayout.NORTH);

		pack();
	}

	private void displayCalendarData() {
		monthLabel.setText(controller.getMonth());
		yearSpinner.setValue(controller.getYear());

		((DefaultTableModel) calendarTable.getModel()).setDataVector(controller
				.getCalendarTable(), DAYS_NAME_TABLE);
	}

	class CalendarAddonController {
		private Calendar calendar;

		private int actualMonthNumber;

		private int actualDayNumber;

		private int actualYearNumber;

		int offset;

		private String[][] daysTable;

		CalendarAddonController() {
			calendar = GregorianCalendar.getInstance();

			actualDayNumber = calendar.get(DAY_OF_MONTH);
			actualMonthNumber = calendar.get(MONTH);
			actualYearNumber = calendar.get(YEAR);

			calendar.set(actualYearNumber, actualMonthNumber, 1);
			daysTable = new String[6][7];
			fillDaysTable();
		}

		public int getYear() {
			return calendar.get(YEAR);
		}

		public int getDay() {
			return calendar.get(DAY_OF_MONTH);
		}

		public String getMonth() {
			return getMonthName(calendar.get(MONTH) + 1);
		}

		public int getActualYear() {
			return actualYearNumber;
		}

		public int getActualDay() {
			return actualDayNumber;
		}

		public String getActualMonth() {
			return getMonthName(actualMonthNumber + 1);
		}

		public String[][] getCalendarTable() {
			return daysTable;
		}

		public String nextMonth() {
			if (calendar.get(MONTH) == 11) {
				calendar.set(calendar.get(YEAR) + 1, 0, 1);
			} else {
				calendar.roll(MONTH, true);
			}
			fillDaysTable();
			return calendarDictionary.get(calendar.get(MONTH) + 1);
		}

		public String previousMonth() {
			if (calendar.get(MONTH) == 0) {
				calendar.set(calendar.get(YEAR) - 1, 11, 1);
			} else {
				calendar.roll(MONTH, false);
			}
			fillDaysTable();
			return calendarDictionary.get(calendar.get(MONTH) + 1);
		}

		public String nextYear() {
			calendar.set(calendar.get(YEAR) + 1, calendar.get(MONTH), 1);
			return calendarDictionary.get(calendar.get(YEAR) + 1);
		}

		public String previousYear() {
			calendar.set(calendar.get(YEAR) - 1, calendar.get(MONTH), 1);
			fillDaysTable();
			return calendarDictionary.get(calendar.get(YEAR) + 1);
		}

		public void rollYear(int year) {
			calendar.set(year, calendar.get(MONTH), 1);
			fillDaysTable();
		}

		private void resetToCurrentDate() {
			calendar.set(actualYearNumber, actualMonthNumber, actualDayNumber);
		}

		private void fillDaysTable() {
			daysTable = new String[6][7];
			offset = calendar.get(DAY_OF_WEEK) - 1;

			for (int i = 0; i < calendar.getActualMaximum(DAY_OF_MONTH); i++) {

				daysTable[((calendar.get(DATE) + offset - 1) / 7)][calendar
						.get(DAY_OF_WEEK) - 1] = Integer.toString(calendar
						.get(DATE));
				calendar.roll(DAY_OF_MONTH, true);
			}
		}
	}

	class SpinnerListener implements ChangeListener {
		public void stateChanged(ChangeEvent evt) {
			JSpinner spinner = (JSpinner) evt.getSource();
			controller.rollYear((Integer) spinner.getValue());
			displayCalendarData();
		}
	}

	class CalendarCellRenderer extends DefaultTableCellRenderer {
		public static final long serialVersionUID = 1L;

		CalendarCellRenderer() {
			super();
		}

		public Component getTableCellRendererComponent(JTable table,
				Object day, boolean isSelected, boolean hasFocus, int row,
				int column) {

			Component comp = super.getTableCellRendererComponent(table, day,
					isSelected, hasFocus, row, column);

			setHorizontalAlignment(SwingConstants.CENTER);

			if (table.getColumnName(column).equals("Nd")) {
				setForeground(Color.red);
			} else {
				if (table.getColumnName(column).equals("So")) {
					setForeground(Color.green);
				} else {
					setForeground(Color.white);
				}
			}

			if (monthLabel.getText().equals(controller.getActualMonth())) {
				if (day != null) {
					if (((String) day).equals("" + controller.getActualDay())) {
						setBackground(Color.gray);
					} else {
						setBackground(Color.black);
					}
				} else {
					setBackground(Color.black);
				}
			} else {
				setBackground(Color.black);
			}

			String newDay = (String) day;

			setHorizontalTextPosition(SwingConstants.CENTER);
			setText(newDay);

			return this;
		}
	}

	private static Hashtable<Integer, String> calendarDictionary = new Hashtable<Integer, String>();

	static {
		calendarDictionary.put(1, "Stycze");
		calendarDictionary.put(2, "Luty");
		calendarDictionary.put(3, "Marzec");
		calendarDictionary.put(4, "Kwiecie");
		calendarDictionary.put(5, "Maj");
		calendarDictionary.put(6, "Czerwiec");
		calendarDictionary.put(7, "Lipiec");
		calendarDictionary.put(8, "Sierpie");
		calendarDictionary.put(9, "Wrzesie");
		calendarDictionary.put(10, "Padziernik");
		calendarDictionary.put(11, "Listopad");
		calendarDictionary.put(12, "Grudzie");
	}

	public static String getMonthName(int monthNumber) {
		return calendarDictionary.get(monthNumber);
	}

	public void mouseClicked(MouseEvent e) {
		if (e.getClickCount() == 2) {
			int row = calendarTable.rowAtPoint(e.getPoint());
			int col = calendarTable.columnAtPoint(e.getPoint());

			if (row > -1 && col > -1) {
				String element = (String) ((DefaultTableModel) calendarTable
						.getModel()).getValueAt(row, col);
				// TODO: Obsluga wpisywania wpisow dla konkretnego dnia
			}
		}

	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mousePressed(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}

	public String getIconPath() {
		return null;
	}

	public String getName() {
		return "Kalendarz";
	}

	public void init() {

		// this.setLocation(poParent.getLocation().x-200,poParent.getLocation().y);
		this.setVisible(true);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		new CalendarAddon().init();
	}

}