package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

public class Bug184 {
	private String[] labels_ = new String[] { "One", "Two" };

	private Component[] components_;
	private JPanel content_;
	private JPanel clientArea_;
	private int selectedIndex_;
	private JTabbedPane tabbedPane_;

	public void run() {
		JFrame mainFrame = new JFrame();
		mainFrame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		content_ = new JPanel(new BorderLayout(10, 10));
		content_.setBorder(new EmptyBorder(10, 10, 10, 10));
		mainFrame.setContentPane(content_);

		clientArea_ = new JPanel(new BorderLayout(10, 10));
		content_.add(clientArea_, BorderLayout.CENTER);

		buildTabbedComponents();
		showTabs();

		JButton switchButton = new JButton(new SwitchAction());
		content_.add(switchButton, BorderLayout.SOUTH);

		mainFrame.setSize(300, 200);
		mainFrame.setVisible(true);
	}

	private void buildTabbedComponents() {
		int num = labels_.length;
		components_ = new Component[num];

		components_[0] = new Label(labels_[0]);

		// create second component
		//
		JTabbedPane tabs = new JTabbedPane();
		tabs.addTab(labels_[1], null, new JLabel(labels_[1]), labels_[1]);
		components_[1] = tabs;

		// this would work, comment out to test the idea
		// components_[1] = new Label(labels_[1]);
	}

	private void showTabs() {
		tabbedPane_ = new JTabbedPane();
		clientArea_.add(tabbedPane_, BorderLayout.CENTER);

		int num = components_.length;
		for (int i = 0; i < num; i++) {
			String title = labels_[i];
			tabbedPane_.addTab(title, null, components_[i], title);
		}

		tabbedPane_.setSelectedIndex(selectedIndex_);
	}

	private class SwitchAction extends AbstractAction {
		public SwitchAction() {
			super("Switch");
		}

		public void actionPerformed(ActionEvent e) {
			if (tabbedPane_ == null) {
				clientArea_.removeAll();

				showTabs();
			} else {
				selectedIndex_ = tabbedPane_.getSelectedIndex();
				tabbedPane_.removeAll();
				clientArea_.removeAll();
				tabbedPane_ = null;

				Component displayedComponent = components_[selectedIndex_];
				displayedComponent.setVisible(false);
				clientArea_.add(displayedComponent, BorderLayout.CENTER);
				displayedComponent.setVisible(true);
			}

			content_.validate();
		}
	}

	public static void main(String[] args) {
		new Bug184().run();
	}
}