package test.check;

import java.awt.*;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;

public class AlignmentPanel {

	public static JComponent getAlignmentPanel() {
		FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref:grow", "");
		DefaultFormBuilder builder = new DefaultFormBuilder(lm);
		builder.setDefaultDialogBorder();

		for (int fontSize = 11; fontSize < 25; fontSize++) {
			builder.append("size " + fontSize, getSubPanel(fontSize));
		}

		return new JScrollPane(builder.getPanel());
	}

	private static JPanel getSubPanel(int size) {
		JPanel result = new JPanel(new FlowLayout(FlowLayout.LEFT));

		Font font = new Font("Arial", Font.PLAIN, size);

		JTextField tf = new JTextField("sample");
		tf.setFont(font);
		result.add(tf);

		JFormattedTextField ftf = new JFormattedTextField("sample");
		ftf.setFont(font);
		result.add(ftf);

		JPasswordField pf = new JPasswordField("sample");
		pf.setFont(font);
		result.add(pf);

		JComboBox cb = new JComboBox(new Object[] { "sample" });
		cb.setFont(font);
		result.add(cb);

		JComboBox ecb = new JComboBox(new Object[] { "sample" });
		ecb.setFont(font);
		ecb.setEditable(true);
		result.add(ecb);

		JSpinner s = new JSpinner(new SpinnerListModel(
				new Object[] { "sample" }));
		s.setFont(font);
		result.add(s);

		return result;
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame frame = new JFrame("Alignment");
				frame.setSize(600, 400);
				frame.setLocationRelativeTo(null);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

				frame.add(getAlignmentPanel(), BorderLayout.CENTER);
				frame.setVisible(true);
			}
		});

	}

}
