package test;

import java.awt.BorderLayout;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;
import org.jvnet.substance.SubstanceLookAndFeel;

public class Table extends JFrame {
	/**
	 * Custom table model.
	 * 
	 * @author Kirill Grouchnikov
	 */
	private static class MyTableModel extends AbstractTableModel {
		/**
		 * The current row count.
		 */
		private int rows;

		/**
		 * The column count.
		 */
		private int cols = 2;

		/**
		 * The table data.
		 */
		private Object[][] data;

		/**
		 * The table column classes.
		 */
		private Class<?>[] columns = new Class<?>[] { String.class,
				//JComboBox.class, 
				Boolean.class};// Byte.class};//, Float.class};//,
				//Double.class, String.class, Date.class, ImageIcon.class,
				//Color.class };

		/**
		 * Creates the custom table model.
		 * 
		 * @param rows
		 *            Initial number of rows.
		 */
		public MyTableModel(int rows) {
			this.rows = rows;
			this.data = new Object[rows][this.cols];
			for (int i = 0; i < rows; i++) {
				this.data[i][0] = "cell " + i + ":" + 0;
//				this.data[i][1] = "predef";
				this.data[i][1] = new Boolean(i % 2 == 0);
				//this.data[i][2] = new Byte((byte) i);
//				this.data[i][4] = new Float(i);
//				this.data[i][5] = new Double(i);
//				this.data[i][6] = "cell " + i + ":" + 6;
//				Calendar cal = Calendar.getInstance();
//				cal.set(2000 + i, 1 + i, 1 + i);
//				this.data[i][7] = cal.getTime();
//				int count = 0;
//				if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
//					for (ThemeInfo themeInfo : SubstanceLookAndFeel
//							.getAllThemes().values()) {
//						if (count++ == i) {
//							try {
//								this.data[i][8] = SubstanceImageCreator
//										.getHexaMarker(
//												6,
//												(SubstanceTheme) Class
//														.forName(
//																themeInfo
//																		.getClassName())
//														.newInstance());
//							} catch (Exception exc) {
//							}
//						}
//					}
//				}
//
//				int comp = i * 20;
//				int red = (comp / 3) % 255;
//				int green = (comp / 2) % 255;
//				int blue = comp % 255;
//				this.data[i][9] = new Color(red, green, blue);
			}
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
		 */
		@Override
		public Class<?> getColumnClass(int columnIndex) {
			return this.columns[columnIndex];
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.TableModel#getColumnCount()
		 */
		public int getColumnCount() {
			return this.cols;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.TableModel#getRowCount()
		 */
		public int getRowCount() {
			return this.rows;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.TableModel#getValueAt(int, int)
		 */
		public Object getValueAt(int row, int col) {
			return this.data[row][col];
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.AbstractTableModel#getColumnName(int)
		 */
		@Override
		public String getColumnName(int column) {
			return this.getColumnClass(column).getSimpleName();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.AbstractTableModel#isCellEditable(int, int)
		 */
//		@Override
//		public boolean isCellEditable(int rowIndex, int columnIndex) {
//			return (rowIndex % 2 == 0);
//		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.table.AbstractTableModel#setValueAt(java.lang.Object,
		 *      int, int)
		 */
		@Override
		public void setValueAt(Object value, int row, int col) {
			this.data[row][col] = value;
			this.fireTableCellUpdated(row, col);
		}
	}

	public Table() {
		super("Some simple text");
		this.setLayout(new BorderLayout());
		JTable table = new JTable(new MyTableModel(1));
		table.setColumnSelectionAllowed(true);
		table.setRowSelectionAllowed(true);
		
//		JComboBox combo = new JComboBox(new Object[] { "aa", "bb", "cc" });
//		combo.setBorder(null);
//		table.getColumnModel().getColumn(1).setCellEditor(
//				new DefaultCellEditor(combo));
//		table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
//		table.setShowGrid(true);
//		table.setDragEnabled(false);
		table.setTableHeader(new JTableHeader(table.getColumnModel()));


		this.add(new JScrollPane(table));

		this.setSize(300, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.put(LafWidget.ANIMATION_KIND, AnimationKind.DEBUG_FAST);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Table().setVisible(true);
			}
		});
	}
}
