package test;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.SubstanceFontUtilities;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class ScaledFonts extends JFrame {
	public ScaledFonts() {
		super("Font scaling");

		JPanel main = new JPanel(new FlowLayout());
		main.add(new JButton("sample"));
		main.add(new JCheckBox("sample"));
		main.add(new JTextField("sample"));

		this.add(main, BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout());
		
		ButtonGroup bg = new ButtonGroup();
		
		JRadioButton fact100 = new JRadioButton("100%");
		fact100.setSelected(true);
		fact100.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				scale(1.0f);
			}
		});
		bg.add(fact100);
		controls.add(fact100);
		
		JRadioButton fact150 = new JRadioButton("150%");
		fact150.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				scale(1.5f);
			}
		});
		bg.add(fact150);
		controls.add(fact150);
		
		JRadioButton fact200 = new JRadioButton("200%");
		fact200.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				scale(2.0f);
			}
		});
		bg.add(fact200);
		controls.add(fact200);
		
		this.add(controls, BorderLayout.SOUTH);
		
		this.setSize(400, 400);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setLocationRelativeTo(null);
	}

	private void scale(final float factor) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SubstanceLookAndFeel.setFontPolicy(SubstanceFontUtilities
						.getScaledFontPolicy(factor));
				try {
					UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
				} catch (Exception exc) {
				}
				SwingUtilities.updateComponentTreeUI(ScaledFonts.this);
			}
		});
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ScaledFonts().setVisible(true);
			}
		});
	}
}
