package test;

import java.awt.FlowLayout;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

import test.check.SubstanceLafChanger;

public class ComponentAlignment extends JFrame {
	public ComponentAlignment() {
		super("Component alignment");
		this.setLayout(new FlowLayout());
		this.add(new JTextField("text field", 8));
		this.add(new JComboBox(new Object[] { "combo box" }));
		this.add(new JFormattedTextField("formatted field"));
		this.add(new JPasswordField("password"));
		this.add(new JSpinner(new SpinnerDateModel()));

		JMenu lafMenu = new JMenu("Look & feel");
		lafMenu.add(SubstanceLafChanger.getMenuItem(this, "Substance",
				"org.jvnet.substance.SubstanceLookAndFeel"));
		lafMenu.add(SubstanceLafChanger.getMenuItem(this, "Metal",
				"javax.swing.plaf.metal.MetalLookAndFeel"));
		lafMenu.add(SubstanceLafChanger.getMenuItem(this, "Windows",
				"com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
		lafMenu.add(SubstanceLafChanger.getMenuItem(this, "Windows Classic",
				"com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel"));
		lafMenu.add(SubstanceLafChanger.getMenuItem(this, "Motif",
				"com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
		JMenuBar jmb = new JMenuBar();
		jmb.add(lafMenu);
		this.setJMenuBar(jmb);

		this.setSize(450, 120);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) {
		// JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				// try {
				// UIManager.setLookAndFeel(new SubstanceLookAndFeel());
				// } catch (Exception exc) {
				// }
				new ComponentAlignment().setVisible(true);
			}
		});
	}
}
