/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceTrait;
import org.jvnet.substance.watermark.SubstanceWatermark;

/**
 * Skin for <b>Substance</b> look and feel.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public interface SubstanceSkin extends SubstanceTrait {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.SubstanceTrait#getDisplayName()
	 */
	public String getDisplayName();

	/**
	 * Sets <code>this</code> skin. Can call any public static method in
	 * {@link SubstanceLookAndFeel} class.
	 * 
	 * @return <code>true</code> if skin has been set successfully,
	 *         <code>false</code> otherwise.
	 */
	public boolean set();

	/**
	 * Returns the theme of <code>this</code> skin. The result may be
	 * <code>null</code> if <code>this</code> skin doesn't define a custom
	 * theme.
	 * 
	 * @return The theme of <code>this</code> skin. The result may be
	 *         <code>null</code> if <code>this</code> skin doesn't define a
	 *         custom theme.
	 */
	public SubstanceTheme getTheme();

	/**
	 * Returns the watermark of <code>this</code> skin. The result may be
	 * <code>null</code> if <code>this</code> skin doesn't define a custom
	 * watermark.
	 * 
	 * @return The watermark of <code>this</code> skin. The result may be
	 *         <code>null</code> if <code>this</code> skin doesn't define a
	 *         custom watermark.
	 */
	public SubstanceWatermark getWatermark();
}
