/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.MatteHeaderPainter;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Mist Silver</code> skin. This class is experimental.
 * 
 * @author Kirill Grouchnikov
 * @since version 4.0
 */
public class MistSilverSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Mist Silver";

	/**
	 * Color scheme for active visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class ActiveTitleScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = new Color(197, 197,
				197);

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = new Color(185, 185,
				185);

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = new Color(170, 170, 170);

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = new Color(152, 152, 152);

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = new Color(152, 152, 152);

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = new Color(152, 152, 152);

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#000000");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return ActiveTitleScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return ActiveTitleScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return ActiveTitleScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return ActiveTitleScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return ActiveTitleScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return ActiveTitleScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return ActiveTitleScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Creates a new <code>Silver</code> skin.
	 */
	public MistSilverSkin() {
		SubstanceTheme activeTheme = new SubstanceTheme(
				new MetallicColorScheme(), "Tint Metallic", ThemeKind.COLD)
				.tint(0.1);
		SubstanceTheme defaultTheme = new SubstanceTheme(
				new MetallicColorScheme(), "Shade Metallic", ThemeKind.COLD)
				.shade(0.05);
		SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme();
		SubstanceTheme activeTitleTheme = new SubstanceTheme(
				new ActiveTitleScheme(), "Silver Active Title", ThemeKind.COLD);

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		// theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
		// new SubstanceTerracottaTheme(), new SubstanceSunGlareTheme(),
		// 0.5).tint(0.2));
		theme.setSelectedTabFadeStart(0.6);
		theme.setSelectedTabFadeEnd(1.0);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		this.theme = theme;
		// theme.addPaintAsActive(JScrollBar.class);
		this.shaper = new StandardButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new MatteGradientPainter();
		this.borderPainter = new ClassicBorderPainter();

		MatteHeaderPainter titlePainter = new MatteHeaderPainter();
		this.titlePainter = titlePainter;

		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
