/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.GlassBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.*;
import org.jvnet.substance.painter.GlassGradientPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstancePlanktonWatermark;

/**
 * <code>Magma</code> skin. This class is part of officially supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class MagmaSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static final String NAME = "Magma";

	/**
	 * Creates a new <code>Magma</code> skin.
	 */
	public MagmaSkin() {
		ColorScheme shiftRed = new ShiftColorScheme(new SunsetColorScheme()
		// {
				// @Override
				// public Color getForegroundColor() {
				// return Color.white;
				// }
				// }
				, Color.red, 0.3);
		final SubstanceTheme defaultTheme = new SubstanceCharcoalTheme();
		SubstanceTheme activeTheme = new SubstanceTheme(shiftRed, "Red sunset",
				ThemeKind.BRIGHT) {
			@Override
			public SubstanceTheme getBorderTheme() {
				return defaultTheme;
			}
		}.saturate(0.4);

		ColorScheme disabledScheme = new ShadeColorScheme(defaultTheme
				.getColorScheme(), 0.5) {
			Color foreColor = new Color(104, 93, 90);

			@Override
			public Color getForegroundColor() {
				return this.foreColor;
			}
		};
		SubstanceTheme disabledTheme = // defaultTheme;
		new SubstanceTheme(disabledScheme, "Disabled Magma", ThemeKind.DARK);

		SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.2);
		SubstanceTheme watermarkTheme = defaultTheme.saturate(0.4);

		SubstanceComplexTheme complexTheme = new SubstanceComplexTheme(NAME,
				ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme, watermarkTheme);
		complexTheme.registerComponentStateTheme(disabledTheme, 0.7f, false,
				ComponentState.DISABLED_UNSELECTED,
				ComponentState.DISABLED_SELECTED);

		complexTheme.registerComponentHighlightStateTheme(activeTheme
				.saturate(-0.2), 0.7f, ComponentState.ROLLOVER_UNSELECTED);
		complexTheme.registerComponentHighlightStateTheme(activeTheme, 0.7f,
				ComponentState.SELECTED);
		complexTheme.registerComponentHighlightStateTheme(activeTheme, 0.9f,
				ComponentState.ROLLOVER_SELECTED);
		complexTheme.registerComponentHighlightStateTheme(activeTheme
				.saturate(-0.2), 0.7f, ComponentState.ARMED,
				ComponentState.ROLLOVER_ARMED);

		this.theme = complexTheme;
		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstancePlanktonWatermark();
		this.gradientPainter = new GlassGradientPainter();
		this.titlePainter = new ArcHeaderPainter();
		
		this.borderPainter = new GlassBorderPainter();
		// this.borderPainter = new DarkBorderPainter(new
		// ClassicBorderPainter());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
