/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.*;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.watermark.SubstanceMagneticFieldWatermark;

/**
 * <code>Challenger Deep</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.2
 */
public class ChallengerDeepSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Challenger Deep";

	/**
	 * Creates a new <code>Challenger Deep</code> skin.
	 */
	public ChallengerDeepSkin() {
		SubstanceTheme activeTheme = new SubstanceUltramarineTheme();
		SubstanceTheme defaultTheme = activeTheme.tone(0.1f);

		ColorScheme disabledScheme = new ToneColorScheme(activeTheme
				.getColorScheme(), 0.3) {
			Color foreColor = new Color(123, 118, 137);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		};
		SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme,
				"Disabled Challenger Deep", ThemeKind.DARK);
		
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		this.theme = theme;
		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstanceMagneticFieldWatermark();
		this.gradientPainter = new GlassGradientPainter();
		this.titlePainter = new ArcHeaderPainter();
		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
