/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

import org.jvnet.substance.grip.DragBumpsGripPainter;
import org.jvnet.substance.grip.GripPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.*;

/**
 * Split pane divider in <code>Substance</code> look and feel.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceSplitPaneDivider extends BasicSplitPaneDivider {
	/**
	 * Background delegate.
	 */
	private SubstanceFillBackgroundDelegate bgDelegate;

	/**
	 * The default grip painter.
	 */
	private static final GripPainter defaultGripPainter = new DragBumpsGripPainter();

	/**
	 * Simple constructor.
	 * 
	 * @param ui
	 *            Associated UI.
	 */
	public SubstanceSplitPaneDivider(SubstanceSplitPaneUI ui) {
		super(ui);
		this.bgDelegate = new SubstanceFillBackgroundDelegate();
		this.splitPane.setBackground(UIManager
				.getColor("SplitPane.dividerFocusColor"));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 */
	@Override
	public void paint(Graphics g) {
		if (SubstanceCoreUtilities.hasFlatAppearance(this.splitPane, false)) {
			this.bgDelegate.updateIfOpaque(g, this.splitPane);
		}

		GripPainter gripPainter = SubstanceCoreUtilities.getGripPainter(
				this.splitPane, defaultGripPainter);
		if (gripPainter != null) {
			// Rectangle bounds = (this.splitPane.getOrientation() ==
			// JSplitPane.VERTICAL_SPLIT) ? new Rectangle(
			// 0, 0, Math.max(20, this.getWidth() / 10), 6)
			// : new Rectangle(0, 0, 6, Math
			// .max(20, this.getHeight() / 10));
			Graphics2D graphics = (Graphics2D) g.create();
			// graphics.translate((this.getWidth() - bounds.getWidth()) / 2,
			// (this
			// .getHeight() - bounds.getHeight()) / 2);
			SubstanceTheme gripTheme = SubstanceCoreUtilities.getTheme(
					this.splitPane,
					this.splitPane.isEnabled() ? ComponentState.DEFAULT
							: ComponentState.DISABLED_UNSELECTED, true, false);
			gripPainter
					.paintGrip(
							this.splitPane,
							graphics,
							gripTheme,
							new Rectangle(0, 0, getWidth(), getHeight()),
							this.splitPane.getOrientation() == JSplitPane.HORIZONTAL_SPLIT,
							this.splitPane.getComponentOrientation());
			graphics.dispose();
		}
		//
		// if (this.splitPane.getOrientation() == JSplitPane.VERTICAL_SPLIT) {
		// int bumpWidth = Math.max(20, this.getWidth() / 10);
		// BufferedImage bumps = SubstanceImageCreator
		// .getDragImage(SubstanceLookAndFeel.getTheme(), false,
		// bumpWidth, 6, false);
		// g.drawImage(bumps, (this.getWidth() - bumps.getWidth()) / 2, (this
		// .getHeight() - bumps.getHeight()) / 2, null);
		// } else {
		// int bumpHeight = Math.max(20, this.getHeight() / 10);
		// BufferedImage bumps = SubstanceImageCreator.getDragImage(
		// SubstanceLookAndFeel.getTheme(), false, 6, bumpHeight,
		// false);
		// g.drawImage(bumps, (this.getWidth() - bumps.getWidth()) / 2, (this
		// .getHeight() - bumps.getHeight()) / 2, null);
		// }

		super.paint(g);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicSplitPaneDivider#createLeftOneTouchButton()
	 */
	@Override
	protected JButton createLeftOneTouchButton() {
		Icon verticalSplit = SubstanceImageCreator.getArrowIcon(
				SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2,
				-1, 0, SwingConstants.NORTH, SubstanceCoreUtilities
						.getActiveTheme(this.splitPane, true));

		Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(
				SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2,
				-1, 0, SwingConstants.WEST, SubstanceCoreUtilities
						.getActiveTheme(this.splitPane, true));

		JButton b = new JButton(
				this.splitPane.getOrientation() == JSplitPane.VERTICAL_SPLIT ? verticalSplit
						: horizontalSplit) {
			// Don't want the button to participate in focus traversable.
			@Override
			public boolean isFocusable() {
				return false;
			}
		};

		b.putClientProperty(SubstanceLookAndFeel.BUTTON_PAINT_NEVER_PROPERTY,
				Boolean.TRUE);
		// fix for issue 281 - set empty border so that the arrow
		// icon is not cropped
		b.setBorder(new EmptyBorder(0, 0, 0, 0));

		b.setRequestFocusEnabled(false);
		b.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		b.setFocusPainted(false);
		b.setBorderPainted(false);
		// b.setOpaque(false);
		return b;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicSplitPaneDivider#createRightOneTouchButton()
	 */
	@Override
	protected JButton createRightOneTouchButton() {
		Icon verticalSplit = SubstanceImageCreator.getArrowIcon(
				SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2,
				-1, 0, SwingConstants.SOUTH, SubstanceCoreUtilities
						.getActiveTheme(this.splitPane, true));

		Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(
				SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2,
				-1, 0, SwingConstants.EAST, SubstanceCoreUtilities
						.getActiveTheme(this.splitPane, true));

		JButton b = new JButton(
				this.splitPane.getOrientation() == JSplitPane.VERTICAL_SPLIT ? verticalSplit
						: horizontalSplit) {
			// Don't want the button to participate in focus traversable.
			@Override
			public boolean isFocusable() {
				return false;
			}
		};

		b.putClientProperty(SubstanceLookAndFeel.BUTTON_PAINT_NEVER_PROPERTY,
				Boolean.TRUE);
		// fix for issue 281 - set empty border so that the arrow
		// icon is not cropped
		b.setBorder(new EmptyBorder(0, 0, 0, 0));

		b.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		b.setFocusPainted(false);
		b.setBorderPainted(false);
		b.setRequestFocusEnabled(false);
		// b.setOpaque(false);
		return b;
	}

	/**
	 * Updates the one-touch buttons.
	 * 
	 * @param orientation
	 *            Split pane orientation.
	 */
	public void updateOneTouchButtons(int orientation) {
		// fix for issue 278 - split pane might not yet have the
		// font installed.
		int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
		if (orientation == JSplitPane.VERTICAL_SPLIT) {
			if (this.leftButton != null) {
				this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(
						fontSize, -2, -1, 0, SwingConstants.NORTH,
						SubstanceCoreUtilities.getActiveTheme(this.splitPane,
								true)));
			}
			if (this.rightButton != null) {
				this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(
						fontSize, -2, -1, 0, SwingConstants.SOUTH,
						SubstanceCoreUtilities.getActiveTheme(this.splitPane,
								true)));
			}
		} else {
			if (this.leftButton != null) {
				this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(
						fontSize, -2, -1, 0, SwingConstants.WEST,
						SubstanceCoreUtilities.getActiveTheme(this.splitPane,
								true)));
			}
			if (this.rightButton != null) {
				this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(
						fontSize, -2, -1, 0, SwingConstants.EAST,
						SubstanceCoreUtilities.getActiveTheme(this.splitPane,
								true)));
			}
		}
	}
}
