/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.util.Iterator;
import java.util.Set;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

import org.jvnet.lafwidget.*;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.menu.MenuSearchWidget;
import org.jvnet.substance.utils.MemoryAnalyzer;

/**
 * UI for menu bars in <b>Substance</b> look and feel.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceMenuBarUI extends BasicMenuBarUI {
	/**
	 * Set of registered widgets. This UI delegate maintains the widget set on
	 * its own since it needs to reset the relevant ({@link Resettable})
	 * widgets on theme change and on locale change.
	 */
	protected Set<?> lafWidgets;

	/**
	 * Delegate for painting the background.
	 */
	private static SubstanceFillBackgroundDelegate backgroundDelegate = new SubstanceFillBackgroundDelegate();

	// /**
	// * Locale change listener. Resets all {@link Resettable} widgets.
	// */
	// private LocaleChangeListener substanceLocaleChangeListener;
	//
	// /**
	// * Theme change listener. Resets all {@link Resettable} widgets.
	// */
	// private ThemeChangeListener substanceThemeChangeListener;

	/**
	 * Hides search panels on all menu bars (both JFrames and JInternalFrames).
	 * 
	 * @param toRepaint
	 *            Indication whether the relevant menu bars should be repainted.
	 */
	public static void hideSearchPanels(final boolean toRepaint) {
		MenuSearchWidget.hideSearchPanels(toRepaint);
	}

	/**
	 * Shows search panels on all menu bars (both JFrames and JInternalFrames).
	 */
	public static void showSearchPanels() {
		MenuSearchWidget.showSearchPanels();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.ComponentUI#createUI(javax.swing.JComponent)
	 */
	public static ComponentUI createUI(JComponent c) {
		if (MemoryAnalyzer.isRunning()) {
			MemoryAnalyzer.enqueueUsage("SubstanceMenuBarUI to be created");
		}
		return new SubstanceMenuBarUI();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#installListeners()
	 */
	@Override
	protected void installListeners() {
		super.installListeners();

		// this.substanceThemeChangeListener = new ThemeChangeListener() {
		// public void themeChanged() {
		// for (Iterator<?> it = lafWidgets.iterator(); it.hasNext();) {
		// LafWidget lw = (LafWidget) it.next();
		// if (lw instanceof Resettable) {
		// ((Resettable) lw).reset();
		// }
		// }
		// }
		// };
		// SubstanceLookAndFeel
		// .registerThemeChangeListener(this.substanceThemeChangeListener);
		//
		// substanceLocaleChangeListener = new LocaleChangeListener() {
		// public void localeChanged() {
		// for (Iterator<?> it = lafWidgets.iterator(); it.hasNext();) {
		// LafWidget lw = (LafWidget) it.next();
		// if (lw instanceof Resettable) {
		// ((Resettable) lw).reset();
		// }
		// }
		// }
		// };
		// SubstanceLookAndFeel
		// .registerLocaleChangeListener(substanceLocaleChangeListener);

		// Installs listeners on all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.installListeners();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#uninstallListeners()
	 */
	@Override
	protected void uninstallListeners() {
		// SubstanceLookAndFeel
		// .unregisterThemeChangeListener(this.substanceThemeChangeListener);
		// this.substanceThemeChangeListener = null;
		//
		// SubstanceLookAndFeel
		// .unregisterLocaleChangeListener(this.substanceLocaleChangeListener);
		// this.substanceLocaleChangeListener = null;

		super.uninstallListeners();

		// Uninstalls defaults on all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.uninstallDefaults();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#installUI(javax.swing.JComponent)
	 */
	@Override
	public void installUI(JComponent c) {
		// Fetches all widgets that were registered for the
		// specified component
		this.lafWidgets = LafWidgetRepository.getRepository()
				.getMatchingWidgets(c);
		super.installUI(c);

		// Installs all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.installUI();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#installDefaults()
	 */
	@Override
	protected void installDefaults() {
		super.installDefaults();

		// Installs defaults on all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.installDefaults();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#uninstallUI(javax.swing.JComponent)
	 */
	@Override
	public void uninstallUI(JComponent c) {
		// System.out.println("Uninstalling MenuBarUI " + this.menuBar);
		if (this.menuBar == null)
			return;

		super.uninstallUI(c);

		// Uninstalls all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.uninstallUI();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.basic.BasicMenuBarUI#uninstallDefaults()
	 */
	@Override
	protected void uninstallDefaults() {
		super.uninstallDefaults();

		// Uninstalls defaults on all widgets
		for (Iterator<?> it = this.lafWidgets.iterator(); it.hasNext();) {
			LafWidget lw = (LafWidget) it.next();
			lw.uninstallDefaults();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.plaf.ComponentUI#update(java.awt.Graphics,
	 *      javax.swing.JComponent)
	 */
	@Override
	public void update(Graphics g, JComponent c) {
		boolean isOpaque = TransitionLayout.isOpaque(c);
		if (isOpaque) {
			SubstanceMenuBarUI.backgroundDelegate.update(g, c, true);
		} else {
			super.update(g, c);
		}
		// GhostPaintingUtils.paintGhostImages(c, g);
	}

	/**
	 * Returns the installed widgets.
	 * 
	 * @return Installed widgets.
	 */
	public Set<?> getLafWidgets() {
		return lafWidgets;
	}
}
