/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.ModelSorter;

public class LexicalSortingAction
extends Action {
    private static final String PREFIX = "View.SortAction.";
    private TreeViewer viewer;

    public LexicalSortingAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(BeansUIPlugin.getResourceString("View.SortAction.label"));
        BeansUIImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
        Preferences prefs = BeansUIPlugin.getDefault().getPluginPreferences();
        boolean checked = prefs.getBoolean("org.springframework.ide.eclipse.beans.ui.view.outline.sort");
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean value, boolean doStore) {
        this.setChecked(value);
        this.viewer.setSorter((ViewerSorter)(value ? new ModelSorter(true) : new ModelSorter(false)));
        this.setToolTipText(value ? BeansUIPlugin.getResourceString("View.SortAction.tooltip.checked") : BeansUIPlugin.getResourceString("View.SortAction.tooltip.unchecked"));
        this.setDescription(value ? BeansUIPlugin.getResourceString("View.SortAction.description.checked") : BeansUIPlugin.getResourceString("View.SortAction.description.unchecked"));
        if (doStore) {
            Preferences prefs = BeansUIPlugin.getDefault().getPluginPreferences();
            prefs.setValue("org.springframework.ide.eclipse.beans.ui.view.outline.sort", value);
            BeansUIPlugin.getDefault().savePluginPreferences();
        }
    }
}

