/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUILabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.RootNode;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public final class BeansViewUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static final Object getSelectedObjects() {
        ArrayList selectedResources = new ArrayList();
        ArrayList selectedNodes = new ArrayList();
        Object[] result = null;
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator it = ssel.iterator();
            while (it.hasNext()) {
                IResource r;
                Object o = it.next();
                if (o instanceof IResource) {
                    selectedResources.add(o);
                    continue;
                }
                if (!(o instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((r = (IResource)a.getAdapter((Class)clazz)) != null) {
                    selectedResources.add(r);
                    continue;
                }
                if (!(o instanceof INode)) continue;
                selectedNodes.add(o);
            }
        }
        result = !selectedResources.isEmpty() && selectedNodes.isEmpty() ? selectedResources.toArray(new IResource[selectedResources.size()]) : (selectedResources.isEmpty() && !selectedNodes.isEmpty() ? selectedNodes.toArray(new INode[selectedNodes.size()]) : null);
        return result;
    }

    public static final BeanNode[] createBeanNodes(IResource[] resources, ConfigNode configNode) {
        return null;
    }

    public static final ConfigNode[] createConfigNodes(IResource[] resources, ProjectNode projectNode) {
        ConfigNode[] configNodes = new ConfigNode[resources.length];
        int i = 0;
        while (i < resources.length) {
            String configName = resources[i].getProjectRelativePath().toString();
            BeansProject beansProject = (BeansProject)projectNode.getProject();
            if (projectNode.getProject().getProject().exists(resources[i].getProjectRelativePath()) && !beansProject.hasConfig(configName)) {
                ConfigNode configNode;
                configNodes[i] = configNode = new ConfigNode(projectNode, configName);
            }
            ++i;
        }
        return configNodes;
    }

    public static final ProjectNode[] createProjectNodes(IResource[] resources, RootNode rootNode) {
        ProjectNode[] projectNodes = new ProjectNode[resources.length];
        int i = 0;
        while (i < resources.length) {
            if (!SpringCoreUtils.isSpringProject((IResource)resources[i])) {
                IProject project = (IProject)resources[i];
                ProjectNode projectNode = new ProjectNode(rootNode, project.getName());
                BeansProject beansProject = new BeansProject(project);
                projectNode.setElement((IModelElement)beansProject);
                projectNodes[i] = projectNode;
            }
            ++i;
        }
        return projectNodes;
    }

    public static final void addBeanNodes(TreeViewer treeViewer, BeanNode[] beanNodes, ConfigNode configNode) {
    }

    public static final void addConfigNodes(TreeViewer treeViewer, ConfigNode[] configNodes, ProjectNode projectNode) {
        int i = 0;
        while (i < configNodes.length) {
            BeansProject beansProject = (BeansProject)projectNode.getProject();
            configNodes[i].setParent(projectNode);
            projectNode.addConfig(configNodes[i].getName());
            beansProject.setConfigs((Collection)projectNode.getConfigNames());
            BeansUILabelDecorator.update();
            treeViewer.add((Object)projectNode, (Object)configNodes[i]);
            treeViewer.reveal((Object)configNodes[i]);
            ++i;
        }
    }

    public static final void addConfigNodes(TreeViewer treeViewer, ConfigNode[] configNodes, ConfigSetNode configSetNode) {
        int i = 0;
        while (i < configNodes.length) {
            ConfigNode droppedConfigNode = configNodes[i];
            if (droppedConfigNode.getProjectNode().getProject().equals(configSetNode.getProjectNode().getProject())) {
                BeansConfigSet beansConfigSet = (BeansConfigSet)configSetNode.getConfigSet();
                BeansProject beansProject = (BeansProject)configSetNode.getProjectNode().getProject();
                beansConfigSet.addConfig(droppedConfigNode.getName());
                configSetNode.addConfig(droppedConfigNode);
                ArrayList<BeansConfigSet> configSets = new ArrayList<BeansConfigSet>();
                Iterator it = configSetNode.getProjectNode().getConfigSets().iterator();
                while (it.hasNext()) {
                    ConfigSetNode node = (ConfigSetNode)it.next();
                    BeansConfigSet configSet = new BeansConfigSet((IBeansProject)beansProject, node.getName(), node.getConfigNames());
                    configSet.setAllowBeanDefinitionOverriding(node.isOverrideEnabled());
                    configSet.setIncomplete(node.isIncomplete());
                    configSets.add(configSet);
                }
                beansProject.setConfigSets(configSets);
                BeansUILabelDecorator.update();
                treeViewer.reveal((Object)configSetNode);
            }
            ++i;
        }
    }

    public static final void addProjectNodes(TreeViewer treeViewer, ProjectNode[] projectNodes, RootNode rootNode) {
        int i = 0;
        while (i < projectNodes.length) {
            SpringCoreUtils.addProjectNature((IProject)projectNodes[i].getProject().getProject(), (String)"org.springframework.ide.eclipse.core.springnature");
            projectNodes[i].setParent(rootNode);
            rootNode.addProject(projectNodes[i].getName(), new ArrayList(), new ArrayList());
            BeansUILabelDecorator.update();
            treeViewer.add((Object)rootNode, (Object)projectNodes[i]);
            treeViewer.reveal((Object)projectNodes[i]);
            ++i;
        }
    }

    public static final ConfigNode[] castToConfigNodes(INode[] nodes) {
        ConfigNode[] configNodes = new ConfigNode[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            configNodes[i] = (ConfigNode)nodes[i];
            ++i;
        }
        return configNodes;
    }

    public static final int getResourcesCommonType(IResource[] resources) {
        int result = 0;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (result != 0 && resource.getType() != result) {
                result = 0;
                break;
            }
            result = resource.getType();
            ++i;
        }
        return result;
    }

    public static final boolean areResourcesFromTheSameProject(IResource[] resources) {
        Object projectId = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (projectId != null && !resource.getProject().getName().equals(projectId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean areAllResourcesJavaProjects(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!SpringCoreUtils.isJavaProject((IResource)resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean areAllResourcesCompilationUnits(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!BeansViewUtils.isCompilationUnit(resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean areAllResourcesXmlFiles(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!BeansViewUtils.isXmlFile(resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isCompilationUnit(IResource resource) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.ICompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return resource.getAdapter((Class)clazz) != null;
    }

    public static final boolean isXmlFile(IResource resource) {
        return resource instanceof IFile && "xml".equalsIgnoreCase(((IFile)resource).getFileExtension());
    }
}

