/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.beans.ui.model.RootNode;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewContentProvider;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewDragAdapter;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewDropAdapter;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewLocation;
import org.springframework.ide.eclipse.beans.ui.views.IBeansView;
import org.springframework.ide.eclipse.beans.ui.views.actions.CollapseAllAction;
import org.springframework.ide.eclipse.beans.ui.views.actions.LexicalSortingAction;
import org.springframework.ide.eclipse.beans.ui.views.actions.OpenBeanClassAction;
import org.springframework.ide.eclipse.beans.ui.views.actions.OpenPropertiesAction;
import org.springframework.ide.eclipse.beans.ui.views.actions.PropertySheetAction;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeansView
extends ViewPart
implements IBeansView,
IShowInSource,
IShowInTarget {
    public static final String VIEW_ID = "org.springframework.ide.eclipse.beans.ui.views.beansView";
    public static final String CONTEXT_MENU_ID = "#BeansViewContext";
    private TreeViewer treeViewer;
    private RootNode rootNode = null;
    private OpenBeanClassAction openBeanClassAction;
    private OpenPropertiesAction openPropertiesAction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = this.createViewer(parent);
        this.initializeActions();
        this.createContextMenu((Viewer)this.treeViewer);
        this.fillToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void initializeActions() {
        this.openBeanClassAction = new OpenBeanClassAction(this);
        this.openPropertiesAction = new OpenPropertiesAction(this);
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 772);
        viewer.setContentProvider((IContentProvider)new BeansViewContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ModelLabelProvider(), (ILabelDecorator)new ModelLabelDecorator()));
        viewer.setInput((Object)this.getRootNode());
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1.toString().compareToIgnoreCase(e2.toString());
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BeansView.this.handleDoubleClick(event);
            }
        });
        viewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DropTargetListener)new BeansViewDropAdapter((Viewer)viewer));
        viewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DragSourceListener)new BeansViewDragAdapter((Viewer)viewer));
        this.getViewSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    private RootNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new RootNode(this);
            this.rootNode.reloadConfigs();
        }
        return this.rootNode;
    }

    private void createContextMenu(Viewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BeansView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(CONTEXT_MENU_ID, menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        if (this.openBeanClassAction.isEnabled()) {
            menuMgr.add((IAction)this.openBeanClassAction);
        }
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.add((IContributionItem)new Separator("additions-end"));
        menuMgr.add((IAction)this.openPropertiesAction);
    }

    private void fillToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.removeAll();
        mgr.add((IAction)new CollapseAllAction(this.treeViewer));
        mgr.add((IAction)new LexicalSortingAction(this.treeViewer));
        mgr.add((IAction)new PropertySheetAction(this));
        mgr.update(false);
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof ProjectNode || elem instanceof ConfigSetNode) {
                if (this.treeViewer.getExpandedState(elem)) {
                    this.treeViewer.collapseToLevel(elem, -1);
                } else {
                    this.treeViewer.expandToLevel(elem, 1);
                }
            } else {
                IResource resource = this.getSelectedResource(selection);
                if (resource instanceof IFile && resource.exists()) {
                    int line = this.getStartLineFromSelectedNode(selection);
                    SpringUIUtils.openInEditor((IFile)((IFile)resource), (int)line);
                }
            }
        }
    }

    public boolean show(ShowInContext context) {
        ISelection selection;
        Object input = context.getInput();
        if (input instanceof BeansViewLocation) {
            return this.showLocation((BeansViewLocation)input);
        }
        if (input instanceof IModelElement) {
            return this.showLocation(BeansUIUtils.getBeansViewLocation((IModelElement)input));
        }
        if (input instanceof IAdaptable) {
            Object resource;
            IAdaptable iAdaptable = (IAdaptable)input;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = iAdaptable.getAdapter((Class)clazz)) != null && this.showResource((IResource)resource)) {
                return true;
            }
        }
        if ((selection = context.getSelection()) != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IModelElement) {
                return this.showLocation(BeansUIUtils.getBeansViewLocation((IModelElement)element));
            }
            if (element instanceof IResource) {
                return this.showResource((IResource)element);
            }
            if (input instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)input;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = iAdaptable.getAdapter((Class)clazz)) != null) {
                    return this.showResource((IResource)element);
                }
            }
        }
        return false;
    }

    private boolean showLocation(BeansViewLocation location) {
        ProjectNode project;
        if (location.hasProjectName() && (project = this.getRootNode().getProject(location.getProjectName())) != null) {
            ConfigSetNode configSet;
            AbstractNode node = project;
            if (location.hasConfigName()) {
                ConfigNode config = project.getConfig(location.getConfigName());
                if (config != null) {
                    BeanNode bean;
                    node = config;
                    if (location.hasBeanName() && (bean = config.getBean(location.getBeanName())) != null) {
                        PropertyNode property;
                        node = bean;
                        if (location.hasPropertyName() && (property = bean.getProperty(location.getPropertyName())) != null) {
                            node = property;
                        }
                    }
                }
            } else if (location.hasConfigSetName() && (configSet = project.getConfigSet(location.getConfigSetName())) != null) {
                BeanNode bean;
                node = configSet;
                if (location.hasBeanName() && (bean = configSet.getBean(location.getBeanName())) != null) {
                    PropertyNode property;
                    node = bean;
                    if (location.hasPropertyName() && (property = bean.getProperty(location.getPropertyName())) != null) {
                        node = property;
                    }
                }
            }
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            return true;
        }
        return false;
    }

    private boolean showResource(IResource resource) {
        AbstractNode node = null;
        if (resource instanceof IFile) {
            node = this.getRootNode().getConfig((IFile)resource);
        } else if (resource instanceof IProject) {
            node = this.getRootNode().getProject(resource.getName());
        } else if (resource instanceof IAdaptable) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jdt.core.IJavaProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.getAdapter((Class)clazz) != null) {
                node = this.getRootNode().getProject(resource.getName());
            }
        }
        if (node != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        IResource resource = this.getSelectedResource(this.getViewer().getSelection());
        if (resource != null && resource.exists()) {
            StructuredSelection selection = new StructuredSelection((Object)resource);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    public void refresh() {
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BeansViewState state = BeansView.this.getState();
                BeansView.this.treeViewer.refresh();
                BeansView.this.setState(state);
            }
        });
    }

    private BeansViewState getState() {
        BeansViewState state = new BeansViewState();
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        int i = 0;
        while (i < expandedElements.length) {
            INode node = (INode)expandedElements[i];
            if (node.getElement() != null) {
                state.expandedElements.add(node.getElement().getElementID());
            }
            ++i;
        }
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            while (selectedElements.hasNext()) {
                INode node = (INode)selectedElements.next();
                state.selectedElements.add(node.getID());
            }
        }
        return state;
    }

    private void setState(BeansViewState state) {
        ArrayList<INode> expandedElements = new ArrayList<INode>();
        Iterator expandedElementIDs = state.expandedElements.iterator();
        while (expandedElementIDs.hasNext()) {
            String elementID = (String)expandedElementIDs.next();
            INode node = this.getRootNode().getNode(elementID);
            if (node == null) continue;
            expandedElements.add(node);
        }
        if (!expandedElements.isEmpty()) {
            this.treeViewer.setExpandedElements((Object[])expandedElements.toArray(new INode[expandedElements.size()]));
        }
        ArrayList<INode> selectedElements = new ArrayList<INode>();
        Iterator selectedElementIDs = state.selectedElements.iterator();
        while (selectedElementIDs.hasNext()) {
            String elementID = (String)selectedElementIDs.next();
            INode node = this.getRootNode().getNode(elementID);
            if (node == null) continue;
            selectedElements.add(node);
        }
        if (!selectedElements.isEmpty()) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
    }

    private IResource getSelectedResource(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof ProjectNode) {
                return ((ProjectNode)elem).getProject().getProject();
            }
            if (elem instanceof ConfigNode) {
                return ((ConfigNode)elem).getConfigFile();
            }
            if (elem instanceof BeanNode) {
                return ((BeanNode)elem).getConfigNode().getConfigFile();
            }
            if (elem instanceof ConstructorArgumentNode) {
                return ((ConstructorArgumentNode)elem).getConfigNode().getConfigFile();
            }
            if (elem instanceof PropertyNode) {
                return ((PropertyNode)elem).getConfigNode().getConfigFile();
            }
        }
        return null;
    }

    private int getStartLineFromSelectedNode(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof BeanNode) {
                return ((BeanNode)elem).getStartLine();
            }
            if (elem instanceof ConstructorArgumentNode) {
                return ((ConstructorArgumentNode)elem).getStartLine();
            }
            if (elem instanceof PropertyNode) {
                return ((PropertyNode)elem).getStartLine();
            }
        }
        return -1;
    }

    public static final IViewPart showView() {
        try {
            return BeansUIPlugin.getActiveWorkbenchPage().showView(VIEW_ID);
        }
        catch (PartInitException e) {
            BeansUIPlugin.log(e);
            return null;
        }
    }

    private static class BeansViewState {
        public List expandedElements = new ArrayList();
        public List selectedElements = new ArrayList();

        BeansViewState() {
        }
    }
}

