/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescription;
import org.springframework.ide.eclipse.beans.core.internal.project.IBeansProjectDescriptionConstants;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansProjectDescriptionHandler
extends DefaultHandler
implements IBeansProjectDescriptionConstants {
    protected static final int S_INITIAL = 0;
    protected static final int S_PROJECT_DESC = 1;
    protected static final int S_CONFIGS = 2;
    protected static final int S_CONFIG = 3;
    protected static final int S_CONFIG_SETS = 4;
    protected static final int S_CONFIG_SET = 5;
    protected static final int S_CONFIG_SET_NAME = 6;
    protected static final int S_CONFIG_SET_OVERRIDING = 7;
    protected static final int S_CONFIG_SET_INCOMPLETE = 8;
    protected static final int S_CONFIG_SET_CONFIGS = 9;
    protected static final int S_CONFIG_SET_CONFIG = 10;
    protected IBeansProject project;
    protected MultiStatus problems;
    protected BeansProjectDescription description;
    protected int state;
    protected BeansConfigSet configSet;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Locator locator;

    public BeansProjectDescriptionHandler(IBeansProject project) {
        this.project = project;
        this.problems = new MultiStatus("org.springframework.ide.eclipse.beans.core", 567, "Error reading Spring project description", null);
        this.description = new BeansProjectDescription(project);
        this.state = 0;
    }

    public IStatus getStatus() {
        return this.problems;
    }

    public BeansProjectDescription getDescription() {
        return this.description;
    }

    public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        switch (this.state) {
            case 0: {
                if (elementName.equals("beansProjectDescription")) {
                    this.state = 1;
                    break;
                }
                throw new SAXParseException("No Spring project description", this.locator);
            }
            case 1: {
                if (elementName.equals("configs")) {
                    this.state = 2;
                    break;
                }
                if (!elementName.equals("configSets")) break;
                this.state = 4;
                break;
            }
            case 2: {
                if (!elementName.equals("config")) break;
                this.state = 3;
                break;
            }
            case 4: {
                if (!elementName.equals("configSet")) break;
                this.state = 5;
                break;
            }
            case 5: {
                if (elementName.equals("name")) {
                    this.state = 6;
                    break;
                }
                if (elementName.equals("allowBeanDefinitionOverriding")) {
                    this.state = 7;
                    break;
                }
                if (elementName.equals("incomplete")) {
                    this.state = 8;
                    break;
                }
                if (!elementName.equals("configs")) break;
                this.state = 9;
                break;
            }
            case 9: {
                if (!elementName.equals("config")) break;
                this.state = 10;
            }
        }
    }

    public void endElement(String uri, String elementName, String qname) throws SAXException {
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                if (!elementName.equals("configs")) break;
                this.state = 1;
                break;
            }
            case 3: {
                String projectPath;
                if (!elementName.equals("config")) break;
                String config = this.charBuffer.toString().trim();
                if (config.length() > 0 && config.charAt(0) == '/' && config.startsWith(projectPath = String.valueOf('/') + this.project.getElementName() + '/')) {
                    config = config.substring(projectPath.length());
                }
                this.description.addConfig(config);
                this.state = 2;
                break;
            }
            case 4: {
                if (!elementName.equals("configSets")) break;
                this.state = 1;
                break;
            }
            case 5: {
                if (!elementName.equals("configSet")) break;
                this.description.addConfigSet(this.configSet);
                this.state = 4;
                break;
            }
            case 6: {
                if (!elementName.equals("name")) break;
                String name = this.charBuffer.toString().trim();
                this.configSet = new BeansConfigSet(this.project, name);
                this.state = 5;
                break;
            }
            case 7: {
                if (!elementName.equals("allowBeanDefinitionOverriding")) break;
                boolean override = Boolean.valueOf(this.charBuffer.toString().trim());
                this.configSet.setAllowBeanDefinitionOverriding(override);
                this.state = 5;
                break;
            }
            case 8: {
                if (!elementName.equals("incomplete")) break;
                boolean incomplete = Boolean.valueOf(this.charBuffer.toString().trim());
                this.configSet.setIncomplete(incomplete);
                this.state = 5;
                break;
            }
            case 9: {
                if (!elementName.equals("configs")) break;
                this.state = 5;
                break;
            }
            case 10: {
                String projectPath;
                if (!elementName.equals("config")) break;
                String config = this.charBuffer.toString().trim();
                if (config.length() > 0 && config.charAt(0) == '/' && config.startsWith(projectPath = String.valueOf('/') + this.project.getElementName() + '/')) {
                    config = config.substring(projectPath.length());
                }
                this.configSet.addConfig(config);
                this.state = 9;
            }
        }
        this.charBuffer.setLength(0);
    }

    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.charBuffer.append(chars, offset, length);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void fatalError(SAXParseException error) throws SAXException {
        this.log(4, error);
        throw error;
    }

    public void error(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    public void warning(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    public void log(int code, Throwable error) {
        this.log(code, error.getMessage(), error);
    }

    public void log(int code, String errorMessage, Throwable error) {
        this.problems.add((IStatus)new Status(code, "org.springframework.ide.eclipse.beans.core", 567, errorMessage, error));
    }
}

