/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io.xml;

import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LineNumberPreservingDOMParser
extends DOMParser {
    private static final String START_LINE = "startLine";
    private static final String END_LINE = "endLine";
    private XMLLocator locator;

    public LineNumberPreservingDOMParser() throws SAXException {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
    }

    public static final int getStartLineNumber(Node node) {
        return LineNumberPreservingDOMParser.getLineNumberFromUserData(node, START_LINE);
    }

    public static final int getEndLineNumber(Node node) {
        return LineNumberPreservingDOMParser.getLineNumberFromUserData(node, END_LINE);
    }

    private static int getLineNumberFromUserData(Node node, String key) {
        String line;
        if (node instanceof NodeImpl && (line = (String)((NodeImpl)node).getUserData(key)) != null && line.length() > 0) {
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.locator = locator;
        this.addLineNumberToCurrentNode(START_LINE);
    }

    public void endDocument(Augmentations augs) throws XNIException {
        super.endDocument(augs);
        this.addLineNumberToCurrentNode(END_LINE);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        super.startElement(element, attributes, augs);
        this.addLineNumberToCurrentNode(START_LINE);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        this.addLineNumberToCurrentNode(END_LINE);
    }

    private void addLineNumberToCurrentNode(String key) throws XNIException {
        try {
            Node node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).setUserData(key, (Object)String.valueOf(this.locator.getLineNumber()), null);
            }
        }
        catch (SAXException e) {
            throw new XNIException((Exception)e);
        }
    }
}

