/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class DefaultBeanDefinitionRegistry
extends AbstractBeanFactory
implements BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowAliasOverriding = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new ArrayList();

    public DefaultBeanDefinitionRegistry() {
    }

    public DefaultBeanDefinitionRegistry(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowAliasOverriding(boolean allowAliasOverriding) {
        this.allowAliasOverriding = allowAliasOverriding;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.beanDefinitionNames.toArray(new String[this.beanDefinitionNames.size()]);
    }

    public boolean containsBeanDefinition(String beanName) {
        String transformedBeanName = this.transformedBeanName(beanName);
        return this.beanDefinitionMap.containsKey(transformedBeanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws BeansException {
        String transformedBeanName = this.transformedBeanName(beanName);
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(transformedBeanName);
        if (bd == null) {
            throw new NoSuchBeanDefinitionException(beanName, this.toString());
        }
        return this.getMergedBeanDefinition(transformedBeanName, bd);
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition = this.beanDefinitionMap.get(beanName);
        if (oldBeanDefinition != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException("Overrides bean '" + oldBeanDefinition + "'");
            }
        } else {
            this.beanDefinitionNames.add(beanName);
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
    }

    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        block3: {
            try {
                super.registerAlias(beanName, alias);
            }
            catch (IllegalArgumentException e) {
                throw new BeanDefinitionStoreException("alias", beanName, e.getMessage());
            }
            catch (BeanDefinitionStoreException e) {
                if (this.allowAliasOverriding) break block3;
                throw e;
            }
        }
    }

    public Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args) throws BeansException {
        throw new BeanCreationException(beanName, "Not implemented");
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        Iterator bdNames = this.beanDefinitionNames.iterator();
        while (bdNames.hasNext()) {
            text.append(bdNames.next());
            if (!bdNames.hasNext()) continue;
            text.append(", ");
        }
        return text.toString();
    }
}

