#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>


#define MAXLEN 256

int main(int argc, char *argv[])
{
  char filename[MAXLEN];

  FILE *tap, *spt, *blk;
  int i, len, n, c;

  if(argc < 2) {
    fprintf(stderr, "usage: %s basename\n", argv[0]);
    exit(1);
  }

  strcpy(filename, argv[1]);
  strcat(filename, ".tap");
  
  tap = fopen(filename, "rb");
  
  if(tap == NULL) {
    fprintf(stderr, "Could not open file %s. %s\n", 
	    filename, strerror(errno));
    exit(1);
  }

  strcpy(filename, argv[1]);
  strcat(filename, ".spt");
  
  spt = fopen(filename, "wt");

  if(spt == NULL) {
    fprintf(stderr, "Could not open file %s. %s\n", 
	    filename, strerror(errno));
    exit(1);
  }
  

  for(i = 0;; i++) {
    c = getc(tap);
    if(c == EOF) break;
    
    len = c + (getc(tap) << 8);
    
    sprintf(filename, "%s.%03i", argv[1], i);

  
    blk = fopen(filename, "wb");

    if(blk == NULL) {
      fprintf(stderr, "Could not open file %s. %s\n", 
	      filename, strerror(errno));
      exit(1);
    }

    fprintf(spt, "%03i %02X %5i OK   Generated by tap2spt\n", 
	    i, getc(tap), len - 2);

    for(n = 0; n < len - 2; n++) {
      putc(getc(tap), blk);
    }
    
    getc(tap);
    
    fclose(blk);
  }

  fclose(tap);
  fclose(spt);

  return 0;
}





