
#include "tools.h"
#include "config.h"
#include "backend_plugins.h"

#include <qfileinfo.h>

#include <klocale.h>
#include <kglobal.h>

#include <fileref.h>
#include <tag.h>
#include <tstring.h>


int Tools::timeByFile(QString file)
{
    QString sFormat=fileExtension(file);

    if( sFormat == "ogg" || sFormat == "flac" || sFormat == "mpc" || sFormat == "mp3" )
    {
        TagLib::FileRef f( file );
        if( !f.isNull() && f.audioProperties() )
        {
            TagLib::AudioProperties *properties = f.audioProperties();
            return properties->length();
        }
    }
    else if( sFormat == "wav" )
    {
        QFileInfo fFile( file );
        return fFile.size()/168000;
    }
    else
    {
        QFileInfo fFile( file );
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(sFormat).decoder);
        int i=plugin.dec.formats.findIndex(sFormat);
        if( i != -1 ) return fFile.size()/(*plugin.dec.file_sizes.at(i));
        i=plugin.dec.synonymous_formats.findIndex(sFormat);
        if( i != -1 ) return fFile.size()/(*plugin.dec.file_sizes.at(0));
        // FIXME this is not correct, we don't know the real size/time, we just take the first size...
    }

    return 0;
}

QString Tools::fileExtension(QString file)
{
    QString sFormat=file;
    int i=sFormat.findRev('.');
    sFormat.remove(0,i+1);
    sFormat.lower();
    return sFormat;
}

QString Tools::fileName(QString file)
{
    QString sName=file;
    int i=sName.findRev('/');
    sName.remove(0,i+1);
    return sName;
}

void Tools::calculateFileOpenStrings()
{
    QStringList list;

    sFileOpenString = "*.wav"; supportedFormats.clear(); supportedFormats.append("wav");
    supportedFormatsWithoutWave.clear();
    sFileOpenStringReplayGain="";

    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        if( (*it).dec.enabled ) {
            for( QStringList::Iterator jt=(*it).dec.formats.begin(); jt!=(*it).dec.formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) {
                    list.append(*jt);
                    sFileOpenString.append( " *."+(*jt) );
                    supportedFormats.append(*jt);
                    supportedFormatsWithoutWave.append(*jt);
                    if( prefs.fileFormat(tools.fileExtension(*jt)).replaygain != "" ) {
                        if( sFileOpenStringReplayGain ) sFileOpenStringReplayGain.append(" ");
                        sFileOpenStringReplayGain.append("*."+(*jt));
                    }
                }
            }
            for( QStringList::Iterator jt=(*it).dec.synonymous_formats.begin(); jt!=(*it).dec.synonymous_formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) {
                    list.append(*jt);
                    sFileOpenString.append( " *."+(*jt) );
                    supportedFormats.append(*jt);
                    supportedFormatsWithoutWave.append(*jt);
                    if( prefs.fileFormat(tools.fileExtension(*jt)).replaygain != "" ) {
                        if( sFileOpenStringReplayGain ) sFileOpenStringReplayGain.append(" ");
                        sFileOpenStringReplayGain.append("*."+(*jt));
                    }
                }
            }
        }
    }
    /*list.clear();
    sFileOpenString.append( "|" ); sFileOpenString.append( i18n("audio files") ); sFileOpenString.append( " (" );
    sFileOpenString.append( "*.wav" );
    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        if( (*it).dec.enabled ) {
            for( QStringList::Iterator jt=(*it).dec.formats.begin(); jt!=(*it).dec.formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) {
                    list.append(*jt);
                    sFileOpenString.append( " *."+(*jt) );
                }
            }
        }
    }*/
    sFileOpenString+="|"+i18n("all supported formats");
    sFileOpenString.append( "\n" );
    sFileOpenString.append( "*.wav|" ); sFileOpenString.append( i18n("wav files")+" (*.wav)" );
    list.clear();
    sFileOpenStringReplayGain+="|"+i18n("all supported formats");
    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        if( (*it).dec.enabled ) {
            for( QStringList::Iterator jt=(*it).dec.formats.begin(); jt!=(*it).dec.formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) {
                    list.append(*jt);
                    sFileOpenString.append( "\n*."+(*jt)+"|" );
                    sFileOpenString.append( (*jt)+" "+i18n("files")+" (*."+(*jt)+")" );
                    if( prefs.fileFormat(tools.fileExtension(*jt)).replaygain != "" ) {
                        sFileOpenStringReplayGain.append("\n*."+(*jt)+"|");
                        sFileOpenStringReplayGain.append( (*jt)+" "+i18n("files")+" (*."+(*jt)+")" );
                    }
                }
            }
            for( QStringList::Iterator jt=(*it).dec.synonymous_formats.begin(); jt!=(*it).dec.synonymous_formats.end(); ++jt ) {
                if( list.findIndex(*jt) == -1 ) {
                    list.append(*jt);
                    sFileOpenString.append( "\n*."+(*jt)+"|" );
                    sFileOpenString.append( (*jt)+" "+i18n("files")+" (*."+(*jt)+")" );
                    if( prefs.fileFormat(tools.fileExtension(*jt)).replaygain != "" ) {
                        sFileOpenStringReplayGain.append("\n*."+(*jt)+"|");
                        sFileOpenStringReplayGain.append( (*jt)+" "+i18n("files")+" (*."+(*jt)+")" );
                    }
                }
            }
        }
    }

    sFileOpenStringWithoutWave = sFileOpenString;
    sFileOpenStringWithoutWave.remove( "*.wav " );
    sFileOpenStringWithoutWave.remove( QString("*.wav|").append(i18n("wav files")).append( "\n") );
    sFileOpenStringWithoutWave.remove( QString("*.wav|").append(i18n("wav files")) );
    sFileOpenStringWithoutWave.remove( "*.wav" );
}

/*QString Tools::getLocalizedString(QString str, QString lang)
{
    if(lang=="default") lang=KGlobal::_locale->language();

    lang+="{";
    int i=str.find(lang);
    if(i==-1) { lang="en{"; i=str.find(lang); }
    str=str.right(str.length()-i-lang.length());
    i=str.find('}');
    str=str.left(i);
    return str;
}*/

QString Tools::getFormatInfoString(QString str, QString format)
{
    format+="{";
    int i=str.find(format);
    if(i==-1) return str;
    str=str.right(str.length()-i-format.length());
    i=str.find('}');
    str=str.left(i);
    return str;
}

QString Tools::stringToHTML(QString str)
{
    QStringList strings=QStringList::split("$soundkonverter-spacer$",str);
    QStringList::Iterator it=strings.begin();
    str=(*it).replace("\\n","</p>\n<p>");
    it++;
    return "<p>"+str+"</p>\n<a href=\""+(*it)+"\">"+(*it)+"</a>";
}

