

#ifndef _SHAREDDIR_H_
#define _SHAREDDIR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <kprocess.h>

class QComboBox;
class QLineEdit;
class QPushButton;

/**
 * @short Shared dir
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class SharedDir : public QWidget
{
    Q_OBJECT
public:
    enum Mode {
        Original, Shared, Metadata, Copy
    };

    /**
     * Default Constructor
     */
    SharedDir( QWidget *parent=0, const char *name=0 );

    int mode();
    QString dir();
    QString calcFilename();

    /**
     * Default Destructor
     */
    virtual ~SharedDir();

public slots:
    void modeChanged(int);
    void selectDir();
    void gotoDir();
    void conversionStarted();
    void conversionStoped();
    void modeInfo();
    void dirInfo();

private:
    QComboBox *cMode;
    QPushButton *pModeInfo;
    QLineEdit *lDir;
    QPushButton *pDirSelect;
    QPushButton *pDirGoto;
    QPushButton *pDirInfo;
    KProcess kfm;
    int lastMode;

};

#endif // _SHAREDDIR_H_
